/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.auth;

import com.microsoft.azure.sdk.iot.deps.util.Base64;
import com.microsoft.azure.sdk.iot.service.Tools;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;

public class SymmetricKey {
    private final transient int MinKeyLengthInBytes = 16;
    private final transient int MaxKeyLengthInBytes = 64;
    private final transient String DeviceKeyLengthInvalid = "DeviceKeyLengthInvalid";
    private final String encryptionMethod = "AES";
    private String primaryKey;
    private String secondaryKey;

    public SymmetricKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            this.primaryKey = Base64.encodeBase64StringLocal((byte[])keyGenerator.generateKey().getEncoded());
            this.secondaryKey = Base64.encodeBase64StringLocal((byte[])keyGenerator.generateKey().getEncoded());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.validateDeviceAuthenticationKey(primaryKey);
        this.primaryKey = primaryKey;
    }

    public String getSecondaryKey() {
        return this.secondaryKey;
    }

    public void setSecondaryKey(String secondaryKey) {
        this.validateDeviceAuthenticationKey(secondaryKey);
        this.secondaryKey = secondaryKey;
    }

    private void validateDeviceAuthenticationKey(String key) throws IllegalArgumentException {
        if (key != null && (key.length() < 16 || key.length() > 64)) {
            throw new IllegalArgumentException("DeviceKeyLengthInvalid");
        }
    }

    public boolean equals(Object other) {
        if (other instanceof SymmetricKey) {
            SymmetricKey otherSymmetricKey = (SymmetricKey)other;
            return Tools.areEqual(this.getPrimaryKey(), otherSymmetricKey.getPrimaryKey()) && Tools.areEqual(this.getSecondaryKey(), otherSymmetricKey.getSecondaryKey());
        }
        return false;
    }
}

