/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.devicetwin;

import com.microsoft.azure.sdk.iot.deps.serializer.MethodParser;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.devicetwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.service.devicetwin.Job;
import com.microsoft.azure.sdk.iot.service.devicetwin.MethodResult;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;

public class DeviceMethod {
    private IotHubConnectionString iotHubConnectionString = null;
    private Integer requestId = 0;
    private static final int DEFAULT_RESPONSE_TIMEOUT = 30;
    private static final int DEFAULT_CONNECT_TIMEOUT = 0;
    private static final int THOUSAND_MS = 1000;

    public static DeviceMethod createFromConnectionString(String connectionString) throws IOException {
        if (connectionString == null || connectionString.length() == 0) {
            throw new IllegalArgumentException("Connection string cannot be null or empty");
        }
        DeviceMethod deviceMethod = new DeviceMethod();
        deviceMethod.iotHubConnectionString = IotHubConnectionStringBuilder.createConnectionString(connectionString);
        return deviceMethod;
    }

    public synchronized MethodResult invoke(String deviceId, String methodName, Long responseTimeoutInSeconds, Long connectTimeoutInSeconds, Object payload) throws IotHubException, IOException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("deviceId is empty or null.");
        }
        if (methodName == null || methodName.isEmpty()) {
            throw new IllegalArgumentException("methodName is empty or null.");
        }
        MethodParser methodParser = new MethodParser(methodName, responseTimeoutInSeconds, connectTimeoutInSeconds, payload);
        String json = methodParser.toJson();
        if (json == null) {
            throw new IllegalArgumentException("MethodParser return null Json");
        }
        URL url = this.iotHubConnectionString.getUrlMethod(deviceId);
        long responseTimeout = responseTimeoutInSeconds == null ? 30L : responseTimeoutInSeconds;
        long connectTimeout = connectTimeoutInSeconds == null ? 0L : connectTimeoutInSeconds;
        long timeoutInMs = (responseTimeout + connectTimeout) * 1000L;
        Integer n = this.requestId;
        Integer n2 = this.requestId = Integer.valueOf(this.requestId + 1);
        HttpResponse response = DeviceOperations.request(this.iotHubConnectionString, url, HttpMethod.POST, json.getBytes(StandardCharsets.UTF_8), String.valueOf(n), timeoutInMs);
        MethodParser methodParserResponse = new MethodParser();
        methodParserResponse.fromJson(new String(response.getBody(), StandardCharsets.UTF_8));
        return new MethodResult(methodParserResponse.getStatus(), methodParserResponse.getPayload());
    }

    public Job scheduleDeviceMethod(String queryCondition, String methodName, Long responseTimeoutInSeconds, Long connectTimeoutInSeconds, Object payload, Date startTimeUtc, long maxExecutionTimeInSeconds) throws IOException, IotHubException {
        if (methodName == null || methodName.isEmpty()) {
            throw new IllegalArgumentException("null updateTwin");
        }
        if (startTimeUtc == null) {
            throw new IllegalArgumentException("null startTimeUtc");
        }
        if (maxExecutionTimeInSeconds < 0L) {
            throw new IllegalArgumentException("negative maxExecutionTimeInSeconds");
        }
        Job job = new Job(this.iotHubConnectionString.toString());
        job.scheduleDeviceMethod(queryCondition, methodName, responseTimeoutInSeconds, connectTimeoutInSeconds, payload, startTimeUtc, maxExecutionTimeInSeconds);
        return job;
    }
}

