/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.devicetwin;

import com.microsoft.azure.sdk.iot.service.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.auth.IotHubServiceSasToken;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubExceptionManager;
import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpRequest;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

public class DeviceOperations {
    private static final String AUTHORIZATION = "authorization";
    private static final String REQUEST_ID = "Request-Id";
    private static final String USER_AGENT = "User-Agent";
    private static final String ACCEPT = "Accept";
    private static final String ACCEPT_VALUE = "application/json";
    private static final String ACCEPT_CHARSET = "charset=utf-8";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final Integer DEFAULT_HTTP_TIMEOUT_MS = 24000;
    private static Map<String, String> headers = null;

    public static HttpResponse request(IotHubConnectionString iotHubConnectionString, URL url, HttpMethod method, byte[] payload, String requestId, long timeoutInMs) throws IOException, IotHubException, IllegalArgumentException {
        if (iotHubConnectionString == null) {
            throw new IllegalArgumentException("Null ConnectionString");
        }
        if (url == null) {
            throw new IllegalArgumentException("Null URL");
        }
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        if (payload == null) {
            throw new IllegalArgumentException("Null payload");
        }
        if (timeoutInMs + (long)DEFAULT_HTTP_TIMEOUT_MS.intValue() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("HTTP Request timeout shouldn't not exceed " + timeoutInMs + DEFAULT_HTTP_TIMEOUT_MS + " milliseconds");
        }
        String sasTokenString = new IotHubServiceSasToken(iotHubConnectionString).toString();
        if (sasTokenString == null || sasTokenString.isEmpty()) {
            throw new IOException("Illegal sasToken null or empty");
        }
        HttpRequest request = new HttpRequest(url, method, payload);
        request.setReadTimeoutMillis((int)(timeoutInMs + (long)DEFAULT_HTTP_TIMEOUT_MS.intValue()));
        request.setHeaderField(AUTHORIZATION, sasTokenString);
        if (requestId != null && !requestId.isEmpty()) {
            request.setHeaderField(REQUEST_ID, requestId);
        }
        request.setHeaderField(USER_AGENT, TransportUtils.getJavaServiceClientIdentifier() + TransportUtils.getServiceVersion());
        request.setHeaderField(ACCEPT, ACCEPT_VALUE);
        request.setHeaderField(CONTENT_TYPE, "application/json; charset=utf-8");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                request.setHeaderField(header.getKey(), header.getValue());
            }
            headers = null;
        }
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        return response;
    }

    public static void setHeaders(Map<String, String> httpHeaders) throws IllegalArgumentException {
        if (httpHeaders == null || httpHeaders.size() == 0) {
            throw new IllegalArgumentException("Null or Empty headers can't be set");
        }
        headers = httpHeaders;
    }
}

