/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.devicetwin;

import com.microsoft.azure.sdk.iot.deps.serializer.TwinParser;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.devicetwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.service.devicetwin.DeviceTwinDevice;
import com.microsoft.azure.sdk.iot.service.devicetwin.Job;
import com.microsoft.azure.sdk.iot.service.devicetwin.Query;
import com.microsoft.azure.sdk.iot.service.devicetwin.QueryCollection;
import com.microsoft.azure.sdk.iot.service.devicetwin.QueryCollectionResponse;
import com.microsoft.azure.sdk.iot.service.devicetwin.QueryOptions;
import com.microsoft.azure.sdk.iot.service.devicetwin.QueryType;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class DeviceTwin {
    private IotHubConnectionString iotHubConnectionString = null;
    private Integer requestId = 0;
    private final long USE_DEFAULT_TIMEOUT = 0L;
    private final int DEFAULT_PAGE_SIZE = 100;

    public static DeviceTwin createFromConnectionString(String connectionString) throws IOException {
        if (connectionString == null || connectionString.length() == 0) {
            throw new IllegalArgumentException("Connection string cannot be null or empty");
        }
        DeviceTwin deviceTwin = new DeviceTwin();
        deviceTwin.iotHubConnectionString = IotHubConnectionStringBuilder.createConnectionString(connectionString);
        return deviceTwin;
    }

    public void getTwin(DeviceTwinDevice device) throws IotHubException, IOException {
        if (device == null || device.getDeviceId() == null || device.getDeviceId().length() == 0) {
            throw new IllegalArgumentException("Instantiate a device and set device id to be used");
        }
        URL url = this.iotHubConnectionString.getUrlTwin(device.getDeviceId());
        Integer n = this.requestId;
        Integer n2 = this.requestId = Integer.valueOf(this.requestId + 1);
        HttpResponse response = DeviceOperations.request(this.iotHubConnectionString, url, HttpMethod.GET, new byte[0], String.valueOf(n), 0L);
        String twin = new String(response.getBody(), StandardCharsets.UTF_8);
        device.getTwinParser().updateTwin(twin);
        device.setETag(device.getTwinParser().getETag());
        device.setTags(device.getTwinParser().getTagsMap());
        device.setDesiredProperties(device.getTwinParser().getDesiredPropertyMap());
        device.setReportedProperties(device.getTwinParser().getReportedPropertyMap());
    }

    public synchronized void updateTwin(DeviceTwinDevice device) throws IotHubException, IOException {
        if (device == null || device.getDeviceId() == null || device.getDeviceId().length() == 0) {
            throw new IllegalArgumentException("Instantiate a device and set device id to be used");
        }
        if ((device.getDesiredMap() == null || device.getDesiredMap().isEmpty()) && (device.getTagsMap() == null || device.getTagsMap().isEmpty())) {
            throw new IllegalArgumentException("Set either desired properties or tags for the device to be updated with");
        }
        URL url = this.iotHubConnectionString.getUrlTwin(device.getDeviceId());
        String twinJson = device.getTwinParser().updateTwin(device.getDesiredMap(), null, device.getTagsMap());
        if (twinJson == null || twinJson.isEmpty()) {
            throw new IOException("Serializer cannot return null json to update");
        }
        Integer n = this.requestId;
        Integer n2 = this.requestId = Integer.valueOf(this.requestId + 1);
        HttpResponse response = DeviceOperations.request(this.iotHubConnectionString, url, HttpMethod.PATCH, twinJson.getBytes(StandardCharsets.UTF_8), String.valueOf(n), 0L);
    }

    public void updateDesiredProperties(DeviceTwinDevice device) throws IotHubException, IOException {
        if (device == null || device.getDeviceId() == null || device.getDeviceId().length() == 0) {
            throw new IllegalArgumentException("Instantiate a device and set device id to be used");
        }
        if (device.getDesiredMap() == null) {
            throw new IllegalArgumentException("Set desired properties for the device to be updated with");
        }
        URL url = this.iotHubConnectionString.getUrlTwinDesired(device.getDeviceId());
        String desiredJson = device.getTwinParser().updateDesiredProperty(device.getDesiredMap());
        if (desiredJson == null) {
            return;
        }
        throw new NotImplementedException();
    }

    public void replaceDesiredProperties(DeviceTwinDevice device) throws IotHubException, IOException {
        if (device == null || device.getDeviceId() == null || device.getDeviceId().length() == 0) {
            throw new IllegalArgumentException("Instantiate a device and set device id to be used");
        }
        if (device.getDesiredMap() == null) {
            throw new IllegalArgumentException("Set desired properties fort he device to be replaced with");
        }
        URL url = this.iotHubConnectionString.getUrlTwinDesired(device.getDeviceId());
        String tags = device.getTwinParser().resetDesiredProperty(device.getDesiredMap());
        if (tags == null || tags.length() == 0) {
            throw new IOException("Serializer cannot return null or empty string");
        }
        throw new NotImplementedException();
    }

    public void replaceTags(DeviceTwinDevice device) throws IotHubException, IOException {
        if (device == null || device.getDeviceId() == null || device.getDeviceId().length() == 0) {
            throw new IllegalArgumentException("Instantiate a device and set device id to be used");
        }
        if (device.getTagsMap() == null) {
            throw new IllegalArgumentException("Set tags to be replaced with");
        }
        URL url = this.iotHubConnectionString.getUrlTwinTags(device.getDeviceId());
        String tags = device.getTwinParser().resetTags(device.getTagsMap());
        if (tags == null || tags.length() == 0) {
            throw new IOException("Serializer cannot return null or empty");
        }
        throw new NotImplementedException();
    }

    public synchronized Query queryTwin(String sqlQuery, Integer pageSize) throws IotHubException, IOException {
        if (sqlQuery == null || sqlQuery.length() == 0) {
            throw new IllegalArgumentException("Query cannot be null or empty");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pagesize cannot be negative or zero");
        }
        Query deviceTwinQuery = new Query(sqlQuery, pageSize, QueryType.TWIN);
        deviceTwinQuery.sendQueryRequest(this.iotHubConnectionString, this.iotHubConnectionString.getUrlTwinQuery(), HttpMethod.POST, 0L);
        return deviceTwinQuery;
    }

    public synchronized Query queryTwin(String sqlQuery) throws IotHubException, IOException {
        return this.queryTwin(sqlQuery, 100);
    }

    public synchronized QueryCollection queryTwinCollection(String sqlQuery) throws MalformedURLException {
        return this.queryTwinCollection(sqlQuery, 100);
    }

    public synchronized QueryCollection queryTwinCollection(String sqlQuery, Integer pageSize) throws MalformedURLException {
        return new QueryCollection(sqlQuery, pageSize, QueryType.TWIN, this.iotHubConnectionString, this.iotHubConnectionString.getUrlTwinQuery(), HttpMethod.POST, 0L);
    }

    public synchronized boolean hasNextDeviceTwin(Query deviceTwinQuery) throws IotHubException, IOException {
        if (deviceTwinQuery == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        return deviceTwinQuery.hasNext();
    }

    public synchronized DeviceTwinDevice getNextDeviceTwin(Query deviceTwinQuery) throws IOException, IotHubException, NoSuchElementException {
        if (deviceTwinQuery == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        Object nextObject = deviceTwinQuery.next();
        if (nextObject instanceof String) {
            String twinJson = (String)nextObject;
            return this.jsonToDeviceTwinDevice(twinJson);
        }
        throw new IOException("Received a response that could not be parsed");
    }

    public synchronized boolean hasNext(QueryCollection deviceTwinQueryCollection) {
        if (deviceTwinQueryCollection == null) {
            throw new IllegalArgumentException("deviceTwinQueryCollection cannot be null");
        }
        return deviceTwinQueryCollection.hasNext();
    }

    public synchronized QueryCollectionResponse<DeviceTwinDevice> next(QueryCollection deviceTwinQueryCollection) throws IOException, IotHubException {
        QueryOptions options = new QueryOptions();
        options.setPageSize(deviceTwinQueryCollection.getPageSize());
        return this.next(deviceTwinQueryCollection, options);
    }

    public synchronized QueryCollectionResponse<DeviceTwinDevice> next(QueryCollection deviceTwinQueryCollection, QueryOptions options) throws IOException, IotHubException {
        if (deviceTwinQueryCollection == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        if (!this.hasNext(deviceTwinQueryCollection)) {
            return null;
        }
        QueryCollectionResponse<String> queryResults = deviceTwinQueryCollection.next(options);
        Iterator<String> jsonCollectionIterator = queryResults.getCollection().iterator();
        ArrayList<DeviceTwinDevice> deviceTwinDeviceList = new ArrayList<DeviceTwinDevice>();
        while (jsonCollectionIterator.hasNext()) {
            deviceTwinDeviceList.add(this.jsonToDeviceTwinDevice(jsonCollectionIterator.next()));
        }
        return new QueryCollectionResponse<DeviceTwinDevice>(deviceTwinDeviceList, queryResults.getContinuationToken());
    }

    public Job scheduleUpdateTwin(String queryCondition, DeviceTwinDevice updateTwin, Date startTimeUtc, long maxExecutionTimeInSeconds) throws IOException, IotHubException {
        if (updateTwin == null) {
            throw new IllegalArgumentException("null updateTwin");
        }
        if (startTimeUtc == null) {
            throw new IllegalArgumentException("null startTimeUtc");
        }
        if (maxExecutionTimeInSeconds < 0L) {
            throw new IllegalArgumentException("negative maxExecutionTimeInSeconds");
        }
        Job job = new Job(this.iotHubConnectionString.toString());
        job.scheduleUpdateTwin(queryCondition, updateTwin, startTimeUtc, maxExecutionTimeInSeconds);
        return job;
    }

    private DeviceTwinDevice jsonToDeviceTwinDevice(String json) throws IOException {
        TwinParser twinParser = new TwinParser();
        twinParser.enableTags();
        twinParser.updateTwin(json);
        DeviceTwinDevice deviceTwinDevice = new DeviceTwinDevice(twinParser.getDeviceId());
        deviceTwinDevice.setVersion(twinParser.getVersion());
        deviceTwinDevice.setETag(twinParser.getETag());
        deviceTwinDevice.setTags(twinParser.getTagsMap());
        deviceTwinDevice.setDesiredProperties(twinParser.getDesiredPropertyMap());
        deviceTwinDevice.setReportedProperties(twinParser.getReportedPropertyMap());
        return deviceTwinDevice;
    }
}

