/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.devicetwin;

import com.microsoft.azure.sdk.iot.deps.serializer.TwinParser;
import com.microsoft.azure.sdk.iot.service.devicetwin.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DeviceTwinDevice {
    private String deviceId = null;
    private String eTag = null;
    private Integer version = null;
    private Map<String, Object> tag = null;
    private Map<String, Object> reportedProperties = null;
    private Map<String, Object> desiredProperties = null;
    private TwinParser twinParser = new TwinParser();

    public DeviceTwinDevice() {
        this.twinParser.enableTags();
    }

    public DeviceTwinDevice(String deviceId) throws IllegalArgumentException {
        this();
        if (deviceId == null || deviceId.length() == 0) {
            throw new IllegalArgumentException("Device ID cannot be null or empty");
        }
        this.deviceId = deviceId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setETag(String eTag) throws IllegalArgumentException {
        if (eTag == null || eTag.length() == 0) {
            throw new IllegalArgumentException("ETag cannot be null or empty");
        }
        this.eTag = eTag;
    }

    public String getETag() {
        return this.eTag;
    }

    void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setTags(Set<Pair> tags) throws IllegalArgumentException {
        if (tags == null) {
            throw new IllegalArgumentException("tags cannot be null");
        }
        this.tag = this.setToMap(tags);
    }

    public Set<Pair> getTags() {
        return this.mapToSet(this.tag);
    }

    public void clearTags() {
        this.tag = null;
    }

    public Set<Pair> getDesiredProperties() {
        return this.mapToSet(this.desiredProperties);
    }

    public void setDesiredProperties(Set<Pair> desiredProperties) throws IllegalArgumentException {
        if (desiredProperties == null) {
            throw new IllegalArgumentException("desiredProperties cannot be null");
        }
        this.desiredProperties = this.setToMap(desiredProperties);
    }

    public void clearDesiredProperties() {
        this.desiredProperties = null;
    }

    public void clearTwin() {
        this.clearTags();
        this.clearDesiredProperties();
    }

    public Set<Pair> getReportedProperties() {
        return this.mapToSet(this.reportedProperties);
    }

    protected void setReportedProperties(Map<String, Object> reportedProperties) {
        this.reportedProperties = reportedProperties;
    }

    protected void setDesiredProperties(Map<String, Object> desiredProperties) {
        this.desiredProperties = desiredProperties;
    }

    protected void setTags(Map<String, Object> tag) {
        this.tag = tag;
    }

    protected Map<String, Object> getTagsMap() {
        return this.tag;
    }

    protected Map<String, Object> getDesiredMap() {
        return this.desiredProperties;
    }

    protected Map<String, Object> getReportedMap() {
        return this.reportedProperties;
    }

    protected TwinParser getTwinParser() {
        return this.twinParser;
    }

    public String toString() {
        StringBuilder thisDevice = new StringBuilder();
        thisDevice.append("Device ID: " + this.getDeviceId() + "\n");
        if (this.getETag() != null) {
            thisDevice.append("ETag: " + this.getETag() + "\n");
        }
        if (this.getVersion() != null) {
            thisDevice.append("Version: " + this.getVersion() + "\n");
        }
        thisDevice.append(this.tagsToString());
        thisDevice.append(this.reportedPropertiesToString());
        thisDevice.append(this.desiredPropertiesToString());
        return thisDevice.toString();
    }

    public String tagsToString() {
        StringBuilder thisDeviceTags = new StringBuilder();
        if (this.tag != null) {
            thisDeviceTags.append("Tags:" + this.tag.toString() + "\n");
        }
        return thisDeviceTags.toString();
    }

    public String desiredPropertiesToString() {
        StringBuilder thisDeviceRepProp = new StringBuilder();
        if (this.desiredProperties != null) {
            thisDeviceRepProp.append("Desired Properties: " + this.desiredProperties.toString() + "\n");
        }
        return thisDeviceRepProp.toString();
    }

    public String reportedPropertiesToString() {
        StringBuilder thisDeviceDesProp = new StringBuilder();
        if (this.reportedProperties != null) {
            thisDeviceDesProp.append("Reported Properties" + this.reportedProperties.toString() + "\n");
        }
        return thisDeviceDesProp.toString();
    }

    private Set<Pair> mapToSet(Map<String, Object> map) {
        HashSet<Pair> setPair = new HashSet<Pair>();
        if (map != null) {
            for (Map.Entry<String, Object> setEntry : map.entrySet()) {
                setPair.add(new Pair(setEntry.getKey(), setEntry.getValue()));
            }
        }
        return setPair;
    }

    private Map<String, Object> setToMap(Set<Pair> set) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (set != null) {
            for (Pair p : set) {
                map.put(p.getKey(), p.getValue());
            }
        }
        return map;
    }
}

