/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.devicetwin;

import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.deps.serializer.QueryRequestParser;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.devicetwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.service.devicetwin.QueryCollectionResponse;
import com.microsoft.azure.sdk.iot.service.devicetwin.QueryOptions;
import com.microsoft.azure.sdk.iot.service.devicetwin.QueryType;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class QueryCollection {
    private static final String CONTINUATION_TOKEN_KEY = "x-ms-continuation";
    private static final String ITEM_TYPE_KEY = "x-ms-item-type";
    private static final String PAGE_SIZE_KEY = "x-ms-max-item-count";
    private int pageSize;
    private String query;
    private boolean isSqlQuery;
    private QueryType requestQueryType;
    private QueryType responseQueryType;
    private String responseContinuationToken;
    private IotHubConnectionString iotHubConnectionString;
    private URL url;
    private HttpMethod httpMethod;
    private long timeout;
    private boolean isInitialQuery;

    protected QueryCollection(String query, int pageSize, QueryType requestQueryType, IotHubConnectionString iotHubConnectionString, URL url, HttpMethod httpMethod, long timeout) {
        this.validateQueryRequestArguments(iotHubConnectionString, url, httpMethod, pageSize, requestQueryType);
        ParserUtility.validateQuery((String)query);
        this.pageSize = pageSize;
        this.query = query;
        this.requestQueryType = requestQueryType;
        this.iotHubConnectionString = iotHubConnectionString;
        this.responseContinuationToken = null;
        this.httpMethod = httpMethod;
        this.timeout = timeout;
        this.url = url;
        this.responseQueryType = QueryType.UNKNOWN;
        this.isSqlQuery = true;
        this.isInitialQuery = true;
    }

    protected QueryCollection(int pageSize, QueryType requestQueryType, IotHubConnectionString iotHubConnectionString, URL url, HttpMethod httpMethod, long timeout) {
        this.validateQueryRequestArguments(iotHubConnectionString, url, httpMethod, pageSize, requestQueryType);
        this.pageSize = pageSize;
        this.requestQueryType = requestQueryType;
        this.query = null;
        this.responseQueryType = QueryType.UNKNOWN;
        this.responseContinuationToken = null;
        this.iotHubConnectionString = iotHubConnectionString;
        this.httpMethod = httpMethod;
        this.timeout = timeout;
        this.url = url;
        this.isSqlQuery = false;
        this.isInitialQuery = true;
    }

    private QueryCollectionResponse<String> sendQueryRequest(QueryOptions options) throws IOException, IotHubException {
        DeviceOperations.setHeaders(this.buildQueryHeaders(options));
        byte[] payload = null;
        if (this.isSqlQuery) {
            QueryRequestParser requestParser = new QueryRequestParser(this.query);
            payload = requestParser.toJson().getBytes();
        } else {
            payload = new byte[]{};
        }
        HttpResponse httpResponse = DeviceOperations.request(this.iotHubConnectionString, this.url, this.httpMethod, payload, null, this.timeout);
        this.handleQueryResponse(httpResponse);
        this.isInitialQuery = false;
        return new QueryCollectionResponse<String>(new String(httpResponse.getBody()), this.responseContinuationToken);
    }

    protected boolean hasNext() {
        if (this.isInitialQuery) {
            return true;
        }
        return this.responseContinuationToken != null;
    }

    protected QueryCollectionResponse<String> next() throws IOException, IotHubException {
        QueryOptions options = new QueryOptions();
        options.setPageSize(this.pageSize);
        return this.next(options);
    }

    protected QueryCollectionResponse<String> next(QueryOptions options) throws IOException, IotHubException {
        if (this.hasNext()) {
            return this.sendQueryRequest(options);
        }
        return null;
    }

    protected Integer getPageSize() {
        return this.pageSize;
    }

    private void validateQueryRequestArguments(IotHubConnectionString iotHubConnectionString, URL url, HttpMethod method, int pageSize, QueryType requestQueryType) {
        if (iotHubConnectionString == null || url == null || method == null) {
            throw new IllegalArgumentException("Input parameters cannot be null");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page Size cannot be zero or negative");
        }
        if (requestQueryType == null || requestQueryType == QueryType.UNKNOWN) {
            throw new IllegalArgumentException("Cannot process a unknown type query");
        }
    }

    private void validateResponseQueryType(QueryType responseQueryType, QueryType requestQueryType) throws IOException {
        if (responseQueryType == null || responseQueryType == QueryType.UNKNOWN) {
            throw new IOException("Query response type is not defined by IotHub");
        }
        if (requestQueryType != responseQueryType) {
            throw new IOException("Query response does not match query request");
        }
    }

    private Map<String, String> buildQueryHeaders(QueryOptions options) {
        HashMap<String, String> queryHeaders = new HashMap<String, String>();
        if (options != null && options.getContinuationToken() != null) {
            queryHeaders.put(CONTINUATION_TOKEN_KEY, options.getContinuationToken());
        } else if (this.responseContinuationToken != null) {
            queryHeaders.put(CONTINUATION_TOKEN_KEY, this.responseContinuationToken);
        }
        if (options != null) {
            queryHeaders.put(PAGE_SIZE_KEY, String.valueOf(options.getPageSize()));
        } else {
            queryHeaders.put(PAGE_SIZE_KEY, String.valueOf(this.pageSize));
        }
        return queryHeaders;
    }

    private void handleQueryResponse(HttpResponse httpResponse) throws IOException {
        Map<String, String> headers = httpResponse.getHeaderFields();
        this.responseContinuationToken = null;
        for (Map.Entry<String, String> header : headers.entrySet()) {
            switch (header.getKey()) {
                case "x-ms-continuation": {
                    this.responseContinuationToken = header.getValue();
                    break;
                }
                case "x-ms-item-type": {
                    this.responseQueryType = QueryType.fromString(header.getValue());
                    break;
                }
            }
        }
        this.validateResponseQueryType(this.responseQueryType, this.requestQueryType);
    }
}

