/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.exceptions;

import com.microsoft.azure.sdk.iot.deps.serializer.ErrorMessageParser;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubBadFormatException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubBadGatewayException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubGatewayTimeoutException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubInternalServerErrorException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubNotFoundException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubPreconditionFailedException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubServerBusyException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubTooManyDevicesException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubTooManyRequestsException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubUnathorizedException;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.nio.charset.StandardCharsets;

public class IotHubExceptionManager {
    public static void httpResponseVerification(HttpResponse httpResponse) throws IotHubBadFormatException, IotHubUnathorizedException, IotHubTooManyDevicesException, IotHubPreconditionFailedException, IotHubTooManyRequestsException, IotHubInternalServerErrorException, IotHubServerBusyException, IotHubBadGatewayException, IotHubNotFoundException, IotHubGatewayTimeoutException, IotHubException {
        int responseStatus = httpResponse.getStatus();
        String errorMessage = ErrorMessageParser.bestErrorMessage((String)new String(httpResponse.getErrorReason(), StandardCharsets.UTF_8));
        if (400 == responseStatus) {
            throw new IotHubBadFormatException(errorMessage);
        }
        if (401 == responseStatus) {
            throw new IotHubUnathorizedException(errorMessage);
        }
        if (403 == responseStatus) {
            throw new IotHubTooManyDevicesException(errorMessage);
        }
        if (404 == responseStatus) {
            throw new IotHubNotFoundException(errorMessage);
        }
        if (412 == responseStatus) {
            throw new IotHubPreconditionFailedException(errorMessage);
        }
        if (429 == responseStatus) {
            throw new IotHubTooManyRequestsException(errorMessage);
        }
        if (500 == responseStatus) {
            throw new IotHubInternalServerErrorException(errorMessage);
        }
        if (502 == responseStatus) {
            throw new IotHubBadGatewayException(errorMessage);
        }
        if (503 == responseStatus) {
            throw new IotHubServerBusyException(errorMessage);
        }
        if (504 == responseStatus) {
            throw new IotHubGatewayTimeoutException(errorMessage);
        }
        if (responseStatus > 300) {
            if (errorMessage.isEmpty()) {
                throw new IotHubException("Unknown error reason");
            }
            throw new IotHubException(errorMessage);
        }
    }
}

