/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.jobs;

import com.microsoft.azure.sdk.iot.deps.serializer.JobsParser;
import com.microsoft.azure.sdk.iot.deps.serializer.MethodParser;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinParser;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.devicetwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.service.devicetwin.DeviceTwinDevice;
import com.microsoft.azure.sdk.iot.service.devicetwin.Pair;
import com.microsoft.azure.sdk.iot.service.devicetwin.Query;
import com.microsoft.azure.sdk.iot.service.devicetwin.QueryType;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.jobs.JobResult;
import com.microsoft.azure.sdk.iot.service.jobs.JobStatus;
import com.microsoft.azure.sdk.iot.service.jobs.JobType;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class JobClient {
    private static final long USE_DEFAULT_TIMEOUT = 0L;
    private static final long MAX_TIMEOUT = 2147459647L;
    private static final Integer DEFAULT_PAGE_SIZE = 100;
    private static final byte[] EMPTY_JSON = "{}".getBytes();
    private IotHubConnectionString iotHubConnectionString = null;

    public static JobClient createFromConnectionString(String connectionString) throws IOException, IllegalArgumentException {
        if (connectionString == null || connectionString.length() == 0) {
            throw new IllegalArgumentException("Connection string cannot be null or empty");
        }
        JobClient jobClient = new JobClient();
        jobClient.iotHubConnectionString = IotHubConnectionStringBuilder.createConnectionString(connectionString);
        return jobClient;
    }

    public synchronized JobResult scheduleUpdateTwin(String jobId, String queryCondition, DeviceTwinDevice updateTwin, Date startTimeUtc, long maxExecutionTimeInSeconds) throws IllegalArgumentException, IOException, IotHubException {
        URL url = null;
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("null jobId");
        }
        if (updateTwin == null) {
            throw new IllegalArgumentException("null updateTwin");
        }
        if (startTimeUtc == null) {
            throw new IllegalArgumentException("null startTimeUtc");
        }
        if (maxExecutionTimeInSeconds < 0L) {
            throw new IllegalArgumentException("negative maxExecutionTimeInSeconds");
        }
        JobsParser jobsParser = new JobsParser(jobId, this.getParserFromDevice(updateTwin), queryCondition, startTimeUtc, maxExecutionTimeInSeconds);
        String json = jobsParser.toJson();
        try {
            url = this.iotHubConnectionString.getUrlJobs(jobId);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid JobId to create url");
        }
        HttpResponse response = DeviceOperations.request(this.iotHubConnectionString, url, HttpMethod.PUT, json.getBytes(StandardCharsets.UTF_8), null, 0L);
        return new JobResult(response.getBody());
    }

    public synchronized JobResult scheduleDeviceMethod(String jobId, String queryCondition, String methodName, Long responseTimeoutInSeconds, Long connectTimeoutInSeconds, Object payload, Date startTimeUtc, long maxExecutionTimeInSeconds) throws IllegalArgumentException, IOException, IotHubException {
        URL url = null;
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("null jobId");
        }
        if (methodName == null || methodName.isEmpty()) {
            throw new IllegalArgumentException("null updateTwin");
        }
        if (startTimeUtc == null) {
            throw new IllegalArgumentException("null startTimeUtc");
        }
        if (maxExecutionTimeInSeconds < 0L) {
            throw new IllegalArgumentException("negative maxExecutionTimeInSeconds");
        }
        MethodParser cloudToDeviceMethod = new MethodParser(methodName, responseTimeoutInSeconds, connectTimeoutInSeconds, payload);
        JobsParser jobsParser = new JobsParser(jobId, cloudToDeviceMethod, queryCondition, startTimeUtc, maxExecutionTimeInSeconds);
        String json = jobsParser.toJson();
        try {
            url = this.iotHubConnectionString.getUrlJobs(jobId);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid JobId to create url");
        }
        HttpResponse response = DeviceOperations.request(this.iotHubConnectionString, url, HttpMethod.PUT, json.getBytes(StandardCharsets.UTF_8), null, 0L);
        return new JobResult(response.getBody());
    }

    public synchronized JobResult getJob(String jobId) throws IllegalArgumentException, IOException, IotHubException {
        URL url;
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("null jobId");
        }
        try {
            url = this.iotHubConnectionString.getUrlJobs(jobId);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid JobId to create url");
        }
        HttpResponse response = DeviceOperations.request(this.iotHubConnectionString, url, HttpMethod.GET, new byte[0], null, 0L);
        return new JobResult(response.getBody());
    }

    public synchronized JobResult cancelJob(String jobId) throws IllegalArgumentException, IOException, IotHubException {
        URL url;
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("null jobId");
        }
        try {
            url = this.iotHubConnectionString.getUrlJobsCancel(jobId);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid JobId to create url");
        }
        HttpResponse response = DeviceOperations.request(this.iotHubConnectionString, url, HttpMethod.POST, EMPTY_JSON, null, 0L);
        return new JobResult(response.getBody());
    }

    private TwinParser getParserFromDevice(DeviceTwinDevice device) throws IOException {
        TwinParser twinParser = new TwinParser();
        twinParser.enableTags();
        if (device.getDeviceId() != null) {
            twinParser.setDeviceId(device.getDeviceId());
        }
        if (device.getETag() == null) {
            twinParser.setETag("*");
        } else {
            twinParser.setETag(device.getETag());
        }
        if (device.getTags() != null) {
            twinParser.resetTags(this.setToMap(device.getTags()));
        }
        if (device.getDesiredProperties() != null) {
            twinParser.resetDesiredProperty(this.setToMap(device.getDesiredProperties()));
        }
        if (device.getReportedProperties() != null) {
            twinParser.resetReportedProperty(this.setToMap(device.getReportedProperties()));
        }
        return twinParser;
    }

    private Map<String, Object> setToMap(Set<Pair> set) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (set != null) {
            for (Pair p : set) {
                map.put(p.getKey(), p.getValue());
            }
        }
        return map;
    }

    public synchronized Query queryDeviceJob(String sqlQuery, Integer pageSize) throws IotHubException, IOException {
        if (sqlQuery == null || sqlQuery.length() == 0) {
            throw new IllegalArgumentException("Query cannot be null or empty");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pagesize cannot be negative or zero");
        }
        Query deviceJobQuery = new Query(sqlQuery, pageSize, QueryType.DEVICE_JOB);
        deviceJobQuery.sendQueryRequest(this.iotHubConnectionString, this.iotHubConnectionString.getUrlTwinQuery(), HttpMethod.POST, 2147459647L);
        return deviceJobQuery;
    }

    public synchronized Query queryDeviceJob(String sqlQuery) throws IotHubException, IOException {
        return this.queryDeviceJob(sqlQuery, DEFAULT_PAGE_SIZE);
    }

    public synchronized boolean hasNextJob(Query query) throws IotHubException, IOException {
        if (query == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        return query.hasNext();
    }

    public synchronized JobResult getNextJob(Query query) throws IOException, IotHubException, NoSuchElementException {
        if (query == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        Object nextObject = query.next();
        if (nextObject instanceof String) {
            String deviceJobJson = (String)nextObject;
            return new JobResult(deviceJobJson.getBytes());
        }
        throw new IOException("Received a response that could not be parsed");
    }

    public synchronized Query queryJobResponse(JobType jobType, JobStatus jobStatus, Integer pageSize) throws IOException, IotHubException {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pagesize cannot be negative or zero");
        }
        Query jobResponseQuery = new Query(pageSize, QueryType.JOB_RESPONSE);
        String jobTypeString = jobType == null ? null : jobType.toString();
        String jobStatusString = jobStatus == null ? null : jobStatus.toString();
        jobResponseQuery.sendQueryRequest(this.iotHubConnectionString, this.iotHubConnectionString.getUrlQuery(jobTypeString, jobStatusString), HttpMethod.GET, 2147459647L);
        return jobResponseQuery;
    }

    public synchronized Query queryJobResponse(JobType jobType, JobStatus jobStatus) throws IotHubException, IOException {
        return this.queryJobResponse(jobType, jobStatus, DEFAULT_PAGE_SIZE);
    }

    protected JobClient() {
    }
}

