/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.jobs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.microsoft.azure.sdk.iot.deps.serializer.JobsResponseParser;
import com.microsoft.azure.sdk.iot.deps.serializer.JobsStatisticsParser;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinParser;
import com.microsoft.azure.sdk.iot.service.devicetwin.DeviceTwinDevice;
import com.microsoft.azure.sdk.iot.service.devicetwin.MethodResult;
import com.microsoft.azure.sdk.iot.service.devicetwin.Pair;
import com.microsoft.azure.sdk.iot.service.jobs.JobStatistics;
import com.microsoft.azure.sdk.iot.service.jobs.JobStatus;
import com.microsoft.azure.sdk.iot.service.jobs.JobType;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JobResult {
    private static final Charset DEFAULT_IOTHUB_MESSAGE_CHARSET = StandardCharsets.UTF_8;
    private String jobId;
    private String queryCondition;
    private Date createdTime;
    private Date startTime;
    private Date lastUpdatedDateTime;
    private Date endTime;
    private Long maxExecutionTimeInSeconds;
    private JobType jobType;
    private JobStatus jobStatus;
    private String cloudToDeviceMethod = null;
    private DeviceTwinDevice updateTwin = null;
    private String failureReason = null;
    private String statusMessage = null;
    private JobStatistics jobStatistics = null;
    private String deviceId = null;
    private String parentJobId = null;
    private String outcome = null;
    private MethodResult outcomeResult = null;
    private String error = null;

    JobResult(byte[] body) throws JsonParseException, IllegalArgumentException {
        TwinParser twinParser;
        if (body == null) {
            throw new IllegalArgumentException("null body");
        }
        String json = new String(body, DEFAULT_IOTHUB_MESSAGE_CHARSET);
        JobsResponseParser jobsResponseParser = JobsResponseParser.createFromJson((String)json);
        this.jobId = jobsResponseParser.getJobId();
        this.queryCondition = jobsResponseParser.getQueryCondition();
        this.createdTime = jobsResponseParser.getCreatedTime();
        this.startTime = jobsResponseParser.getStartTime();
        this.endTime = jobsResponseParser.getEndTime();
        this.lastUpdatedDateTime = jobsResponseParser.getLastUpdatedTimeDate();
        this.maxExecutionTimeInSeconds = jobsResponseParser.getMaxExecutionTimeInSeconds();
        this.jobType = JobType.valueOf(jobsResponseParser.getType());
        this.jobStatus = JobStatus.valueOf(jobsResponseParser.getJobsStatus());
        if (jobsResponseParser.getCloudToDeviceMethod() != null) {
            this.cloudToDeviceMethod = jobsResponseParser.getCloudToDeviceMethod().toJson();
        }
        if (jobsResponseParser.getOutcome() != null) {
            this.outcome = jobsResponseParser.getOutcome().toJson();
            if (this.jobType == JobType.scheduleDeviceMethod) {
                try {
                    this.outcomeResult = new MethodResult(jobsResponseParser.getOutcome().getStatus(), jobsResponseParser.getOutcome().getPayload());
                }
                catch (IllegalArgumentException e) {
                    this.outcomeResult = null;
                }
            }
        }
        if (jobsResponseParser.getError() != null) {
            this.error = jobsResponseParser.getError().toJson();
        }
        if ((twinParser = jobsResponseParser.getUpdateTwin()) != null) {
            this.updateTwin = twinParser.getDeviceId() == null || twinParser.getDeviceId().isEmpty() ? new DeviceTwinDevice() : new DeviceTwinDevice(twinParser.getDeviceId());
            this.updateTwin.setETag(twinParser.getETag());
            try {
                this.updateTwin.setTags(this.mapToSet(twinParser.getTagsMap()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.updateTwin.setDesiredProperties(this.mapToSet(twinParser.getDesiredPropertyMap()));
        }
        this.failureReason = jobsResponseParser.getFailureReason();
        this.statusMessage = jobsResponseParser.getStatusMessage();
        JobsStatisticsParser jobsStatisticsParser = jobsResponseParser.getJobStatistics();
        if (jobsStatisticsParser != null) {
            this.jobStatistics = new JobStatistics(jobsStatisticsParser);
        }
        this.deviceId = jobsResponseParser.getDeviceId();
        this.parentJobId = jobsResponseParser.getParentJobId();
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getQueryCondition() {
        return this.queryCondition;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Long getMaxExecutionTimeInSeconds() {
        return this.maxExecutionTimeInSeconds;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public String getCloudToDeviceMethod() {
        return this.cloudToDeviceMethod;
    }

    public DeviceTwinDevice getUpdateTwin() {
        return this.updateTwin;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public JobStatistics getJobStatistics() {
        return this.jobStatistics;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getParentJobId() {
        return this.parentJobId;
    }

    public Date getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    @Deprecated
    public String getOutcome() {
        return this.outcome;
    }

    public MethodResult getOutcomeResult() {
        return this.outcomeResult;
    }

    public String getError() {
        return this.error;
    }

    public String toString() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        return gson.toJson((Object)this);
    }

    private Set<Pair> mapToSet(Map<String, Object> map) {
        HashSet<Pair> setPair = new HashSet<Pair>();
        if (map != null) {
            for (Map.Entry<String, Object> setEntry : map.entrySet()) {
                setPair.add(new Pair(setEntry.getKey(), setEntry.getValue()));
            }
        }
        return setPair;
    }
}

