/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.deps.serializer.AuthenticationParser;
import com.microsoft.azure.sdk.iot.deps.serializer.AuthenticationTypeParser;
import com.microsoft.azure.sdk.iot.deps.serializer.DeviceParser;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.deps.serializer.SymmetricKeyParser;
import com.microsoft.azure.sdk.iot.deps.serializer.X509ThumbprintParser;
import com.microsoft.azure.sdk.iot.service.DeviceConnectionState;
import com.microsoft.azure.sdk.iot.service.Tools;
import com.microsoft.azure.sdk.iot.service.auth.AuthenticationMechanism;
import com.microsoft.azure.sdk.iot.service.auth.AuthenticationType;
import com.microsoft.azure.sdk.iot.service.auth.SymmetricKey;
import java.util.Date;

public class BaseDevice {
    protected final String UTC_TIME_DEFAULT = "0001-01-01T00:00:00";
    protected final String OFFSET_TIME_DEFAULT = "0001-01-01T00:00:00-00:00";
    protected String deviceId;
    protected String generationId;
    protected String eTag;
    protected DeviceConnectionState connectionState;
    protected String connectionStateUpdatedTime;
    protected String lastActivityTime;
    protected long cloudToDeviceMessageCount;
    private Boolean forceUpdate;
    AuthenticationMechanism authentication;

    protected BaseDevice(String deviceId, SymmetricKey symmetricKey) throws IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("Device Id cannot be null or empty.");
        }
        this.authentication = symmetricKey == null ? new AuthenticationMechanism(AuthenticationType.SAS) : new AuthenticationMechanism(symmetricKey);
        this.setPropertiesToDefaultValues();
        this.deviceId = deviceId;
    }

    protected BaseDevice(String deviceId, AuthenticationType authenticationType) {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("The provided device Id must not be null or empty");
        }
        if (authenticationType == null) {
            throw new IllegalArgumentException("The provided authentication type must not be null");
        }
        this.authentication = new AuthenticationMechanism(authenticationType);
        this.setPropertiesToDefaultValues();
        this.deviceId = deviceId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getGenerationId() {
        return this.generationId;
    }

    public SymmetricKey getSymmetricKey() {
        if (this.authentication == null) {
            return null;
        }
        return this.authentication.getSymmetricKey();
    }

    public void setSymmetricKey(SymmetricKey symmetricKey) throws IllegalArgumentException {
        if (symmetricKey == null) {
            throw new IllegalArgumentException("Symmetric key cannot be null");
        }
        if (this.authentication == null) {
            this.authentication = new AuthenticationMechanism(symmetricKey);
        } else {
            this.authentication.setSymmetricKey(symmetricKey);
        }
    }

    public String getPrimaryKey() {
        if (this.getSymmetricKey() == null) {
            return null;
        }
        return this.getSymmetricKey().getPrimaryKey();
    }

    public String getSecondaryKey() {
        if (this.getSymmetricKey() == null) {
            return null;
        }
        return this.getSymmetricKey().getSecondaryKey();
    }

    @Deprecated
    public void setThumbprint(String primaryThumbprint, String secondaryThumbprint) {
        if (Tools.isNullOrEmpty(primaryThumbprint).booleanValue() || Tools.isNullOrEmpty(secondaryThumbprint).booleanValue()) {
            throw new IllegalArgumentException("Thumbprint may not be null or empty");
        }
        if (this.authentication == null) {
            this.authentication = new AuthenticationMechanism(AuthenticationType.SELF_SIGNED);
        }
        this.authentication.setPrimaryThumbprint(primaryThumbprint);
        this.authentication.setSecondaryThumbprint(secondaryThumbprint);
    }

    public final void setThumbprintFinal(String primaryThumbprint, String secondaryThumbprint) {
        if (Tools.isNullOrEmpty(primaryThumbprint).booleanValue() || Tools.isNullOrEmpty(secondaryThumbprint).booleanValue()) {
            throw new IllegalArgumentException("Thumbprint may not be null or empty");
        }
        if (this.authentication == null) {
            this.authentication = new AuthenticationMechanism(AuthenticationType.SELF_SIGNED);
        }
        this.authentication.setPrimaryThumbprint(primaryThumbprint);
        this.authentication.setSecondaryThumbprint(secondaryThumbprint);
    }

    public String getPrimaryThumbprint() {
        if (this.authentication == null) {
            return null;
        }
        return this.authentication.getPrimaryThumbprint();
    }

    public String getSecondaryThumbprint() {
        if (this.authentication == null) {
            return null;
        }
        return this.authentication.getSecondaryThumbprint();
    }

    public String geteTag() {
        return this.eTag;
    }

    public DeviceConnectionState getConnectionState() {
        return this.connectionState;
    }

    public String getConnectionStateUpdatedTime() {
        return this.connectionStateUpdatedTime;
    }

    public String getLastActivityTime() {
        return this.lastActivityTime;
    }

    public long getCloudToDeviceMessageCount() {
        return this.cloudToDeviceMessageCount;
    }

    public void setForceUpdate(Boolean forceUpdate) throws IllegalArgumentException {
        if (forceUpdate == null) {
            throw new IllegalArgumentException();
        }
        this.forceUpdate = forceUpdate;
    }

    public AuthenticationType getAuthenticationType() {
        if (this.authentication == null) {
            return null;
        }
        return this.authentication.getAuthenticationType();
    }

    DeviceParser toDeviceParser() {
        DeviceParser deviceParser = new DeviceParser();
        deviceParser.setCloudToDeviceMessageCount(this.cloudToDeviceMessageCount);
        deviceParser.setConnectionState(this.connectionState.toString());
        deviceParser.setConnectionStateUpdatedTime(ParserUtility.getDateTimeUtc((String)this.connectionStateUpdatedTime));
        deviceParser.setDeviceId(this.deviceId);
        deviceParser.seteTag(this.eTag);
        deviceParser.setLastActivityTime(ParserUtility.getDateTimeUtc((String)this.lastActivityTime));
        deviceParser.setGenerationId(this.generationId);
        deviceParser.setAuthenticationParser(new AuthenticationParser());
        deviceParser.getAuthenticationParser().setType(AuthenticationTypeParser.valueOf((String)this.authentication.getAuthenticationType().toString()));
        if (this.authentication.getAuthenticationType() != AuthenticationType.CERTIFICATE_AUTHORITY) {
            if (this.authentication.getAuthenticationType() == AuthenticationType.SELF_SIGNED) {
                if (Tools.isNullOrEmpty(this.authentication.getPrimaryThumbprint()).booleanValue() || Tools.isNullOrEmpty(this.authentication.getSecondaryThumbprint()).booleanValue()) {
                    throw new IllegalStateException("Device object using self signed authentication needs to have both primary and secondary thumbprints");
                }
                deviceParser.getAuthenticationParser().setThumbprint(new X509ThumbprintParser(this.getPrimaryThumbprint(), this.getSecondaryThumbprint()));
            } else if (this.authentication.getAuthenticationType() == AuthenticationType.SAS) {
                if (this.authentication.getSymmetricKey() == null || Tools.isNullOrEmpty(this.authentication.getSymmetricKey().getPrimaryKey()).booleanValue() || Tools.isNullOrEmpty(this.authentication.getSymmetricKey().getSecondaryKey()).booleanValue()) {
                    throw new IllegalStateException("Device object using SAS authentication needs to have both primary and secondary keys");
                }
                deviceParser.getAuthenticationParser().setSymmetricKey(new SymmetricKeyParser(this.getPrimaryKey(), this.getSecondaryKey()));
            }
        }
        return deviceParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    BaseDevice(DeviceParser parser) throws IllegalArgumentException {
        if (parser.getAuthenticationParser() == null || parser.getAuthenticationParser().getType() == null) {
            throw new IllegalArgumentException("deviceParser must have an authentication type assigned");
        }
        if (parser.getDeviceId() == null) {
            throw new IllegalArgumentException("deviceParser must have a deviceId assigned");
        }
        AuthenticationType authenticationType = AuthenticationType.valueOf(parser.getAuthenticationParser().getType().toString());
        this.deviceId = parser.getDeviceId();
        this.authentication = new AuthenticationMechanism(authenticationType);
        this.cloudToDeviceMessageCount = parser.getCloudToDeviceMessageCount();
        this.deviceId = parser.getDeviceId();
        this.eTag = parser.geteTag();
        this.generationId = parser.getGenerationId();
        if (parser.getConnectionStateUpdatedTime() != null) {
            this.connectionStateUpdatedTime = ParserUtility.getDateStringFromDate((Date)parser.getConnectionStateUpdatedTime());
        }
        if (parser.getLastActivityTime() != null) {
            this.lastActivityTime = ParserUtility.getDateStringFromDate((Date)parser.getLastActivityTime());
        }
        if (parser.getConnectionState() != null) {
            this.connectionState = DeviceConnectionState.valueOf(parser.getConnectionState());
        }
        this.authentication = new AuthenticationMechanism(authenticationType);
        if (authenticationType == AuthenticationType.CERTIFICATE_AUTHORITY) return;
        if (authenticationType == AuthenticationType.SELF_SIGNED) {
            if (parser.getAuthenticationParser().getThumbprint() == null || parser.getAuthenticationParser().getThumbprint().getPrimaryThumbprintFinal() == null || parser.getAuthenticationParser().getThumbprint().getSecondaryThumbprintFinal() == null) throw new IllegalArgumentException("AuthenticationParser object in the provided DeviceParser object is missing one or more thumbprint values");
            this.setThumbprintFinal(parser.getAuthenticationParser().getThumbprint().getPrimaryThumbprintFinal(), parser.getAuthenticationParser().getThumbprint().getSecondaryThumbprintFinal());
            return;
        } else {
            if (authenticationType != AuthenticationType.SAS) return;
            if (parser.getAuthenticationParser().getSymmetricKey() == null || parser.getAuthenticationParser().getSymmetricKey().getPrimaryKeyFinal() == null || parser.getAuthenticationParser().getSymmetricKey().getSecondaryKeyFinal() == null) throw new IllegalArgumentException("AuthenticationParser object in the provided DeviceParser object is missing one or more symmetric keys");
            this.getSymmetricKey().setPrimaryKeyFinal(parser.getAuthenticationParser().getSymmetricKey().getPrimaryKeyFinal());
            this.getSymmetricKey().setSecondaryKeyFinal(parser.getAuthenticationParser().getSymmetricKey().getSecondaryKeyFinal());
        }
    }

    private void setPropertiesToDefaultValues() {
        this.generationId = "";
        this.eTag = "";
        this.connectionState = DeviceConnectionState.Disconnected;
        this.connectionStateUpdatedTime = "0001-01-01T00:00:00";
        this.lastActivityTime = "0001-01-01T00:00:00-00:00";
        this.cloudToDeviceMessageCount = 0L;
        this.setForceUpdate(false);
    }
}

