/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.deps.serializer.ConfigurationContentParser;
import com.microsoft.azure.sdk.iot.deps.serializer.ConfigurationMetricsParser;
import com.microsoft.azure.sdk.iot.deps.serializer.ConfigurationParser;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.service.ConfigurationContent;
import com.microsoft.azure.sdk.iot.service.ConfigurationMetrics;
import com.microsoft.azure.sdk.iot.service.Tools;
import java.util.Date;
import java.util.HashMap;

public class Configuration {
    protected final String UTC_TIME_DEFAULT = "0001-01-01T00:00:00";
    protected String id;
    protected String schemaVersion;
    protected HashMap<String, String> labels = null;
    protected ConfigurationContent content;
    protected String targetCondition;
    protected String createdTimeUtc;
    protected String lastUpdatedTimeUtc;
    protected Integer priority;
    protected ConfigurationMetrics systemMetrics = null;
    protected ConfigurationMetrics metrics = null;
    protected String etag;
    private Boolean forceUpdate;

    public Configuration(String configurationId) {
        this();
        if (Tools.isNullOrEmpty(configurationId).booleanValue()) {
            throw new IllegalArgumentException("configuration id cannot be null or empty");
        }
        this.id = configurationId;
    }

    private Configuration() {
        this.schemaVersion = "1.0";
        this.metrics = new ConfigurationMetrics();
        this.etag = "";
        this.lastUpdatedTimeUtc = "0001-01-01T00:00:00";
        this.createdTimeUtc = "0001-01-01T00:00:00";
    }

    public String getId() {
        return this.id;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setLabels(HashMap<String, String> labels) {
        this.labels = labels;
    }

    public HashMap<String, String> getLabels() {
        return this.labels;
    }

    public void setContent(ConfigurationContent content) {
        this.content = content;
    }

    public ConfigurationContent getContent() {
        return this.content;
    }

    public void setTargetCondition(String targetCondition) {
        this.targetCondition = targetCondition;
    }

    public String getTargetCondition() {
        return this.targetCondition;
    }

    public String getCreatedTimeUtc() {
        return this.createdTimeUtc;
    }

    public String getLastUpdatedTimeUtc() {
        return this.lastUpdatedTimeUtc;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public ConfigurationMetrics getSystemMetrics() {
        return this.systemMetrics;
    }

    public ConfigurationMetrics getMetrics() {
        return this.metrics;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setForceUpdate(Boolean forceUpdate) throws IllegalArgumentException {
        if (forceUpdate == null) {
            throw new IllegalArgumentException("forceUpdate cannot be null");
        }
        this.forceUpdate = forceUpdate;
    }

    ConfigurationParser toConfigurationParser() {
        ConfigurationContentParser parser;
        ConfigurationParser configurationParser = new ConfigurationParser();
        configurationParser.setId(this.id);
        configurationParser.setSchemaVersion(this.schemaVersion);
        configurationParser.setLabels(this.labels);
        configurationParser.setTargetCondition(this.targetCondition);
        configurationParser.setCreatedTimeUtc(ParserUtility.getDateTimeUtc((String)this.createdTimeUtc));
        configurationParser.setLastUpdatedTimeUtc(ParserUtility.getDateTimeUtc((String)this.lastUpdatedTimeUtc));
        configurationParser.setPriority(this.priority);
        configurationParser.setETag(this.etag);
        if (this.content != null) {
            parser = new ConfigurationContentParser();
            parser.setDeviceContent(this.content.getDeviceContent());
            parser.setModulesContent(this.content.getModulesContent());
            configurationParser.setContent(parser);
        }
        if (this.systemMetrics != null) {
            parser = new ConfigurationMetricsParser();
            parser.setQueries(this.systemMetrics.getQueries());
            parser.setResults(this.systemMetrics.getResults());
            configurationParser.setSystemMetrics((ConfigurationMetricsParser)parser);
        }
        if (this.metrics != null) {
            parser = new ConfigurationMetricsParser();
            parser.setQueries(this.metrics.getQueries());
            parser.setResults(this.metrics.getResults());
            configurationParser.setMetrics((ConfigurationMetricsParser)parser);
        }
        return configurationParser;
    }

    Configuration(ConfigurationParser parser) throws IllegalArgumentException {
        if (parser.getId() == null) {
            throw new IllegalArgumentException("configurationParser must have a configurationId assigned");
        }
        this.id = parser.getId();
        this.schemaVersion = parser.getSchemaVersion();
        this.labels = parser.getLabels();
        this.targetCondition = parser.getTargetCondition();
        this.priority = parser.getPriority();
        this.etag = parser.getETag();
        if (parser.getContent() != null) {
            this.content = new ConfigurationContent();
            this.content.deviceContent = parser.getContent().getDeviceContent();
            this.content.modulesContent = parser.getContent().getModulesContent();
        }
        if (parser.getCreatedTimeUtc() != null) {
            this.createdTimeUtc = ParserUtility.getDateStringFromDate((Date)parser.getCreatedTimeUtc());
        }
        if (parser.getLastUpdatedTimeUtc() != null) {
            this.lastUpdatedTimeUtc = ParserUtility.getDateStringFromDate((Date)parser.getLastUpdatedTimeUtc());
        }
        if (parser.getSystemMetrics() != null) {
            this.systemMetrics = new ConfigurationMetrics();
            this.systemMetrics.queries = parser.getSystemMetrics().getQueries();
            this.systemMetrics.results = parser.getSystemMetrics().getResults();
        }
        if (parser.getMetrics() != null) {
            this.metrics = new ConfigurationMetrics();
            this.metrics.queries = parser.getMetrics().getQueries();
            this.metrics.results = parser.getMetrics().getResults();
        }
    }
}

