/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.deps.serializer.DeviceCapabilitiesParser;
import com.microsoft.azure.sdk.iot.deps.serializer.DeviceParser;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.deps.twin.DeviceCapabilities;
import com.microsoft.azure.sdk.iot.service.BaseDevice;
import com.microsoft.azure.sdk.iot.service.DeviceStatus;
import com.microsoft.azure.sdk.iot.service.Tools;
import com.microsoft.azure.sdk.iot.service.auth.AuthenticationType;
import com.microsoft.azure.sdk.iot.service.auth.SymmetricKey;
import java.util.Date;

public class Device
extends BaseDevice {
    protected DeviceStatus status;
    protected String statusReason;
    private String scope;
    protected String statusUpdatedTime;
    protected DeviceCapabilities capabilities;

    public static Device createFromId(String deviceId, DeviceStatus status, SymmetricKey symmetricKey) throws IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException(deviceId);
        }
        return new Device(deviceId, status, symmetricKey);
    }

    public static Device createDevice(String deviceId, AuthenticationType authenticationType) {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("The provided device Id must not be null or empty");
        }
        if (authenticationType == null) {
            throw new IllegalArgumentException("The provided authentication type must not be null");
        }
        return new Device(deviceId, authenticationType);
    }

    protected Device(String deviceId, DeviceStatus status, SymmetricKey symmetricKey) throws IllegalArgumentException {
        super(deviceId, symmetricKey);
        this.setPropertiesToDefaultValues();
        this.status = status != null ? status : DeviceStatus.Enabled;
    }

    private Device(String deviceId, AuthenticationType authenticationType) {
        super(deviceId, authenticationType);
        this.setPropertiesToDefaultValues();
    }

    public DeviceStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeviceStatus status) {
        this.status = status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public String getStatusUpdatedTime() {
        return this.statusUpdatedTime;
    }

    public DeviceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(DeviceCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    DeviceParser toDeviceParser() {
        DeviceParser deviceParser = super.toDeviceParser();
        deviceParser.setStatus(this.status.toString());
        deviceParser.setStatusReason(this.statusReason);
        deviceParser.setStatusUpdatedTime(ParserUtility.getDateTimeUtc((String)this.statusUpdatedTime));
        if (this.capabilities != null) {
            deviceParser.setCapabilities(new DeviceCapabilitiesParser());
            deviceParser.getCapabilities().setIotEdge(this.capabilities.isIotEdge());
        }
        deviceParser.setScope(this.scope);
        return deviceParser;
    }

    Device(DeviceParser parser) throws IllegalArgumentException {
        super(parser);
        this.statusReason = parser.getStatusReason();
        if (parser.getCapabilities() != null) {
            this.capabilities = new DeviceCapabilities();
            this.capabilities.setIotEdge(parser.getCapabilities().getIotEdge());
        }
        if (parser.getStatusUpdatedTime() != null) {
            this.statusUpdatedTime = ParserUtility.getDateStringFromDate((Date)parser.getStatusUpdatedTime());
        }
        if (parser.getStatus() != null) {
            this.status = DeviceStatus.fromString(parser.getStatus());
        }
        this.scope = parser.getScope();
    }

    private void setPropertiesToDefaultValues() {
        this.status = DeviceStatus.Enabled;
        this.statusReason = "";
        this.statusUpdatedTime = "0001-01-01T00:00:00";
        this.scope = "";
    }
}

