/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.deps.serializer.AuthenticationParser;
import com.microsoft.azure.sdk.iot.deps.serializer.AuthenticationTypeParser;
import com.microsoft.azure.sdk.iot.deps.serializer.ExportImportDeviceParser;
import com.microsoft.azure.sdk.iot.deps.serializer.SymmetricKeyParser;
import com.microsoft.azure.sdk.iot.deps.serializer.X509ThumbprintParser;
import com.microsoft.azure.sdk.iot.deps.twin.TwinCollection;
import com.microsoft.azure.sdk.iot.service.DeviceStatus;
import com.microsoft.azure.sdk.iot.service.ImportMode;
import com.microsoft.azure.sdk.iot.service.Tools;
import com.microsoft.azure.sdk.iot.service.auth.AuthenticationMechanism;
import com.microsoft.azure.sdk.iot.service.auth.AuthenticationType;
import java.util.UUID;

public class ExportImportDevice {
    private String id;
    private String eTag;
    private ImportMode importMode;
    private DeviceStatus status;
    private String statusReason;
    private AuthenticationMechanism authentication;
    private TwinCollection tags = null;
    private TwinCollection reportedProperties = null;
    private TwinCollection desiredProperties = null;

    public ExportImportDevice() {
        this.authentication = new AuthenticationMechanism(AuthenticationType.SAS);
        this.id = "exportImportDevice_" + UUID.randomUUID();
    }

    public ExportImportDevice(String deviceId, AuthenticationType authenticationType) throws IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("DeviceId cannot be null.");
        }
        if (authenticationType == null) {
            throw new IllegalArgumentException("AuthenticationType cannot be null");
        }
        this.authentication = new AuthenticationMechanism(authenticationType);
        this.id = deviceId;
    }

    public void setId(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("The provided id may not be null");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String geteTag() {
        return this.eTag;
    }

    public void seteTag(String eTag) {
        this.eTag = eTag;
    }

    public ImportMode getImportMode() {
        return this.importMode;
    }

    public void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
    }

    public DeviceStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeviceStatus status) {
        this.status = status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public AuthenticationMechanism getAuthenticationFinal() {
        return this.authentication;
    }

    public void setAuthentication(AuthenticationMechanism authentication) throws IllegalArgumentException {
        if (authentication == null) {
            throw new IllegalArgumentException("The provided authentication object may not be null");
        }
        this.authentication = authentication;
    }

    public TwinCollection getTags() {
        return this.tags;
    }

    public void setTags(TwinCollection tags) {
        this.tags = tags;
    }

    public TwinCollection getReportedProperties() {
        return this.reportedProperties;
    }

    public void setReportedProperties(TwinCollection reportedProperties) {
        this.reportedProperties = reportedProperties;
    }

    public TwinCollection getDesiredProperties() {
        return this.desiredProperties;
    }

    public void setDesiredProperties(TwinCollection desiredProperties) {
        this.desiredProperties = desiredProperties;
    }

    public boolean equals(Object other) {
        if (other instanceof ExportImportDevice) {
            ExportImportDevice otherExportImportDevice = (ExportImportDevice)other;
            if (!Tools.areEqual(this.getAuthenticationFinal(), otherExportImportDevice.getAuthenticationFinal())) {
                return false;
            }
            if (!Tools.areEqual((Object)this.getStatus(), (Object)otherExportImportDevice.getStatus())) {
                return false;
            }
            return Tools.areEqual((Object)this.getImportMode(), (Object)otherExportImportDevice.getImportMode());
        }
        return false;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.authentication.hashCode();
        return result;
    }

    ExportImportDevice(ExportImportDeviceParser parser) throws IllegalArgumentException {
        if (parser.getIdFinal() == null) {
            throw new IllegalArgumentException("The id property of the parser object may not be null");
        }
        if (parser.getAuthenticationFinal() == null) {
            throw new IllegalArgumentException("The authentication property of the parser object may not be null");
        }
        this.eTag = parser.getETag();
        this.id = parser.getIdFinal();
        this.statusReason = parser.getStatusReason();
        if (parser.getImportMode() != null) {
            this.importMode = ImportMode.valueOf(parser.getImportMode());
        }
        if (parser.getStatus() != null) {
            this.status = DeviceStatus.fromString(parser.getStatus());
        }
        this.authentication = new AuthenticationMechanism(AuthenticationType.valueOf(parser.getAuthenticationFinal().getType().toString()));
        if (this.authentication.getAuthenticationType() != AuthenticationType.CERTIFICATE_AUTHORITY) {
            if (this.authentication.getAuthenticationType() == AuthenticationType.SELF_SIGNED) {
                if (parser.getAuthenticationFinal().getThumbprint() == null || Tools.isNullOrEmpty(parser.getAuthenticationFinal().getThumbprint().getPrimaryThumbprintFinal()).booleanValue() || Tools.isNullOrEmpty(parser.getAuthenticationFinal().getThumbprint().getSecondaryThumbprintFinal()).booleanValue()) {
                    this.authentication = new AuthenticationMechanism(this.authentication.getAuthenticationType());
                } else {
                    String primaryThumbprint = parser.getAuthenticationFinal().getThumbprint().getPrimaryThumbprintFinal();
                    String secondaryThumbprint = parser.getAuthenticationFinal().getThumbprint().getSecondaryThumbprintFinal();
                    this.authentication = new AuthenticationMechanism(primaryThumbprint, secondaryThumbprint);
                }
            } else if (this.authentication.getAuthenticationType() == AuthenticationType.SAS) {
                if (parser.getAuthenticationFinal().getSymmetricKey() == null || Tools.isNullOrEmpty(parser.getAuthenticationFinal().getSymmetricKey().getPrimaryKeyFinal()).booleanValue() || Tools.isNullOrEmpty(parser.getAuthenticationFinal().getSymmetricKey().getSecondaryKeyFinal()).booleanValue()) {
                    this.authentication = new AuthenticationMechanism(AuthenticationType.SAS);
                } else {
                    String primaryKey = parser.getAuthenticationFinal().getSymmetricKey().getPrimaryKeyFinal();
                    String secondaryKey = parser.getAuthenticationFinal().getSymmetricKey().getSecondaryKeyFinal();
                    this.authentication.getSymmetricKey().setPrimaryKeyFinal(primaryKey);
                    this.authentication.getSymmetricKey().setSecondaryKeyFinal(secondaryKey);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ExportImportDeviceParser toExportImportDeviceParser() {
        ExportImportDeviceParser parser = new ExportImportDeviceParser();
        parser.setETag(this.eTag);
        parser.setId(this.id);
        parser.setStatusReason(this.statusReason);
        if (this.importMode != null) {
            parser.setImportMode(this.importMode.toString());
        }
        if (this.status != null) {
            parser.setStatus(this.status.toString());
        }
        if (this.authentication != null) {
            parser.setAuthentication(new AuthenticationParser());
            if (this.getAuthenticationFinal().getAuthenticationType() != null) {
                parser.getAuthenticationFinal().setType(AuthenticationTypeParser.valueOf((String)this.authentication.getAuthenticationType().toString()));
                if (this.getAuthenticationFinal().getAuthenticationType() != AuthenticationType.CERTIFICATE_AUTHORITY) {
                    if (this.getAuthenticationFinal().getAuthenticationType() == AuthenticationType.SELF_SIGNED) {
                        if (this.authentication.getPrimaryThumbprint() == null || this.authentication.getSecondaryThumbprint() == null) throw new IllegalStateException("ExportImportDevice cannot have self signed authentication without a complete thumbprint.");
                        parser.getAuthenticationFinal().setThumbprint(new X509ThumbprintParser(this.authentication.getPrimaryThumbprint(), this.authentication.getSecondaryThumbprint()));
                    } else if (this.getAuthenticationFinal().getAuthenticationType() == AuthenticationType.SAS) {
                        if (this.authentication.getSymmetricKey() == null || this.authentication.getSymmetricKey().getPrimaryKey() == null || this.authentication.getSymmetricKey().getSecondaryKey() == null) throw new IllegalStateException("ExportImportDevice cannot have SAS authentication without a complete symmetric key.");
                        parser.getAuthenticationFinal().setSymmetricKey(new SymmetricKeyParser(this.authentication.getSymmetricKey().getPrimaryKey(), this.authentication.getSymmetricKey().getSecondaryKey()));
                    }
                }
            }
        }
        parser.setTags(this.tags);
        return parser;
    }
}

