/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.service.FeedbackBatch;
import com.microsoft.azure.sdk.iot.service.IotHubServiceClientProtocol;
import com.microsoft.azure.sdk.iot.service.Receiver;
import com.microsoft.azure.sdk.iot.service.Tools;
import com.microsoft.azure.sdk.iot.service.transport.amqps.AmqpReceive;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FeedbackReceiver
extends Receiver {
    private final long DEFAULT_TIMEOUT_MS = 60000L;
    private final ExecutorService executor = Executors.newFixedThreadPool(10);
    private String deviceId;
    private AmqpReceive amqpReceive;

    @Deprecated
    public FeedbackReceiver(String hostName, String userName, String sasToken, IotHubServiceClientProtocol iotHubServiceClientProtocol, String deviceId) {
        if (Tools.isNullOrEmpty(hostName).booleanValue()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        if (Tools.isNullOrEmpty(userName).booleanValue()) {
            throw new IllegalArgumentException("userName cannot be null or empty");
        }
        if (Tools.isNullOrEmpty(sasToken).booleanValue()) {
            throw new IllegalArgumentException("sasToken cannot be null or empty");
        }
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("deviceId cannot be null or empty");
        }
        this.deviceId = deviceId;
        this.amqpReceive = new AmqpReceive(hostName, userName, sasToken, iotHubServiceClientProtocol);
    }

    public FeedbackReceiver(String hostName, String userName, String sasToken, IotHubServiceClientProtocol iotHubServiceClientProtocol) {
        if (Tools.isNullOrEmpty(hostName).booleanValue()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        if (Tools.isNullOrEmpty(userName).booleanValue()) {
            throw new IllegalArgumentException("userName cannot be null or empty");
        }
        if (Tools.isNullOrEmpty(sasToken).booleanValue()) {
            throw new IllegalArgumentException("sasToken cannot be null or empty");
        }
        if (iotHubServiceClientProtocol == null) {
            throw new IllegalArgumentException("iotHubServiceClientProtocol cannot be null");
        }
        this.amqpReceive = new AmqpReceive(hostName, userName, sasToken, iotHubServiceClientProtocol);
    }

    public void open() throws IOException {
        if (this.amqpReceive == null) {
            throw new IOException("AMQP receiver is not initialized");
        }
        this.amqpReceive.open();
    }

    public void close() throws IOException {
        if (this.amqpReceive == null) {
            throw new IOException("AMQP receiver is not initialized");
        }
        this.amqpReceive.close();
    }

    public FeedbackBatch receive() throws IOException, InterruptedException {
        return this.receive(60000L);
    }

    public FeedbackBatch receive(long timeoutMs) throws IOException, InterruptedException {
        if (this.amqpReceive == null) {
            throw new IOException("AMQP receiver is not initialized");
        }
        return this.amqpReceive.receive(timeoutMs);
    }

    @Override
    public CompletableFuture<Void> openAsync() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            try {
                this.open();
                future.complete(null);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            try {
                this.close();
                future.complete(null);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<FeedbackBatch> receiveAsync() {
        return this.receiveAsync(60000L);
    }

    public CompletableFuture<FeedbackBatch> receiveAsync(long timeoutMs) {
        CompletableFuture<FeedbackBatch> future = new CompletableFuture<FeedbackBatch>();
        this.executor.submit(() -> {
            try {
                FeedbackBatch responseFeedbackBatch = this.receive(timeoutMs);
                future.complete(responseFeedbackBatch);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
            catch (InterruptedException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }
}

