/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.service.FileUploadNotification;
import com.microsoft.azure.sdk.iot.service.IotHubServiceClientProtocol;
import com.microsoft.azure.sdk.iot.service.Receiver;
import com.microsoft.azure.sdk.iot.service.Tools;
import com.microsoft.azure.sdk.iot.service.transport.amqps.AmqpFileUploadNotificationReceive;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FileUploadNotificationReceiver
extends Receiver {
    private final long DEFAULT_TIMEOUT_MS = 60000L;
    private final ExecutorService executor = Executors.newFixedThreadPool(3);
    private AmqpFileUploadNotificationReceive amqpFileUploadNotificationReceive;

    FileUploadNotificationReceiver(String hostName, String userName, String sasToken, IotHubServiceClientProtocol iotHubServiceClientProtocol) {
        if (Tools.isNullOrEmpty(hostName).booleanValue()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        if (Tools.isNullOrEmpty(userName).booleanValue()) {
            throw new IllegalArgumentException("userName cannot be null or empty");
        }
        if (Tools.isNullOrEmpty(sasToken).booleanValue()) {
            throw new IllegalArgumentException("sasToken cannot be null or empty");
        }
        if (iotHubServiceClientProtocol == null) {
            throw new IllegalArgumentException("iotHubServiceClientProtocol cannot be null");
        }
        this.amqpFileUploadNotificationReceive = new AmqpFileUploadNotificationReceive(hostName, userName, sasToken, iotHubServiceClientProtocol);
    }

    public void open() throws IOException {
        this.amqpFileUploadNotificationReceive.open();
    }

    public void close() throws IOException {
        this.amqpFileUploadNotificationReceive.close();
    }

    public FileUploadNotification receive() throws IOException, InterruptedException {
        return this.receive(60000L);
    }

    public FileUploadNotification receive(long timeoutMs) throws IOException, InterruptedException {
        if (this.amqpFileUploadNotificationReceive == null) {
            throw new IOException("AMQP receiver is not initialized");
        }
        return this.amqpFileUploadNotificationReceive.receive(timeoutMs);
    }

    @Override
    public CompletableFuture<Void> openAsync() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            try {
                this.open();
                future.complete(null);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            try {
                this.close();
                future.complete(null);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<FileUploadNotification> receiveAsync() {
        return this.receiveAsync(60000L);
    }

    public CompletableFuture<FileUploadNotification> receiveAsync(long timeoutMs) {
        CompletableFuture<FileUploadNotification> future = new CompletableFuture<FileUploadNotification>();
        this.executor.submit(() -> {
            try {
                FileUploadNotification responseFileUploadNotification = this.receive(timeoutMs);
                future.complete(responseFileUploadNotification);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
            catch (InterruptedException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }
}

