/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.service.AuthenticationMethod;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.Tools;
import java.net.MalformedURLException;
import java.net.URL;

public class IotHubConnectionString
extends IotHubConnectionStringBuilder {
    protected static final String VALUE_PAIR_DELIMITER = ";";
    protected static final String VALUE_PAIR_SEPARATOR = "=";
    protected static final String HOST_NAME_SEPARATOR = ".";
    protected static final String HOST_NAME_PROPERTY_NAME = "HostName";
    protected static final String SHARED_ACCESS_KEY_NAME_PROPERTY_NAME = "SharedAccessKeyName";
    protected static final String SHARED_ACCESS_KEY_PROPERTY_NAME = "SharedAccessKey";
    protected static final String SHARED_ACCESS_SIGNATURE_PROPERTY_NAME = "SharedAccessSignature";
    protected String hostName;
    protected String iotHubName;
    protected AuthenticationMethod authenticationMethod;
    protected String sharedAccessKeyName;
    protected String sharedAccessKey;
    protected String sharedAccessSignature;
    private static final String URL_SEPARATOR_0 = "/";
    private static final String URL_SEPARATOR_1 = "?";
    private static final String URL_SEPARATOR_2 = "&";
    private static final String URL_HTTPS = "https://";
    private static final String URL_PATH_DEVICES = "devices";
    private static final String URL_PATH_MODULES = "modules";
    private static final String URL_PATH_CONFIG = "configurations";
    private static final String URL_API_VERSION = "api-version=2019-03-30";
    private static final String URL_MAX_COUNT = "top=";
    private static final String URL_PATH_DEVICESTATISTICS = "statistics";
    private static final String USER_SEPARATOR = "@";
    private static final String USER_SAS = "SAS.";
    private static final String USER_ROOT = "root.";
    private static final String URL_PATH_TWIN = "twins";
    private static final String URL_PATH_PROPERTIES = "properties";
    private static final String URL_PATH_METHODS = "methods";
    private static final String URL_PATH_TWIN_DEVICES = "devices";
    private static final String URL_PATH_JOBS = "jobs";
    private static final String URL_PATH_VERSION = "v2";
    private static final String URL_PATH_QUERY = "query";
    private static final String URL_PATH_JOB_TYPE = "jobType";
    private static final String URL_PATH_JOB_STATUS = "jobStatus";
    private static final String URL_PATH_CANCEL = "cancel";
    private static final String URL_PATH_APPLY_CONTENT_CONFIGURATION = "applyConfigurationContent";

    protected IotHubConnectionString() {
    }

    public String getUserString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.sharedAccessKeyName);
        stringBuilder.append(USER_SEPARATOR);
        stringBuilder.append(USER_SAS);
        stringBuilder.append(USER_ROOT);
        stringBuilder.append(this.iotHubName);
        return stringBuilder.toString();
    }

    public URL getUrlMethod(String deviceId) throws MalformedURLException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_TWIN);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(deviceId);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_METHODS);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlModuleMethod(String deviceId, String moduleId) throws MalformedURLException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        if (Tools.isNullOrEmpty(moduleId).booleanValue()) {
            throw new IllegalArgumentException("module name cannot be empty or null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_TWIN);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(deviceId);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_MODULES);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(moduleId);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_METHODS);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlJobs(String jobId) throws MalformedURLException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(jobId).booleanValue()) {
            throw new IllegalArgumentException("job name cannot be empty or null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_JOBS);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_VERSION);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(jobId);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlTwinQuery() throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append("devices");
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_QUERY);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlQuery(String jobType, String jobStatus) throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_JOBS);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_VERSION);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_QUERY);
        stringBuilder.append(URL_SEPARATOR_1);
        if (!Tools.isNullOrEmpty(jobType).booleanValue()) {
            stringBuilder.append(URL_PATH_JOB_TYPE);
            stringBuilder.append(VALUE_PAIR_SEPARATOR);
            stringBuilder.append(jobType);
            stringBuilder.append(URL_SEPARATOR_2);
        }
        if (!Tools.isNullOrEmpty(jobStatus).booleanValue()) {
            stringBuilder.append(URL_PATH_JOB_STATUS);
            stringBuilder.append(VALUE_PAIR_SEPARATOR);
            stringBuilder.append(jobStatus);
            stringBuilder.append(URL_SEPARATOR_2);
        }
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlJobsCancel(String jobId) throws MalformedURLException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(jobId).booleanValue()) {
            throw new IllegalArgumentException("job name cannot be empty or null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_JOBS);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_VERSION);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(jobId);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_CANCEL);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlTwin(String deviceId) throws MalformedURLException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_TWIN);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(deviceId);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlModuleTwin(String deviceId, String moduleId) throws MalformedURLException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        if (Tools.isNullOrEmpty(moduleId).booleanValue()) {
            throw new IllegalArgumentException("module id cannot be empty or null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_TWIN);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(deviceId);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_MODULES);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(moduleId);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlDevice(String deviceId) throws MalformedURLException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append("devices");
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(deviceId);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlModule(String deviceId, String moduleId) throws MalformedURLException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        if (Tools.isNullOrEmpty(moduleId).booleanValue()) {
            throw new IllegalArgumentException("module name cannot be empty or null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append("devices");
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(deviceId);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_MODULES);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(moduleId);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlApplyConfigurationContent(String deviceId) throws MalformedURLException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("deviceId cannot be null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append("devices");
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(deviceId);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_APPLY_CONTENT_CONFIGURATION);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlConfiguration(String configurationId) throws MalformedURLException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(configurationId).booleanValue()) {
            throw new IllegalArgumentException("configuration id cannot be empty or null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_CONFIG);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(configurationId);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlConfigurationsList(Integer maxCount) throws MalformedURLException, IllegalArgumentException {
        if (maxCount == null || maxCount < 1) {
            throw new IllegalArgumentException("maxCount cannot be null or less then 1");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_CONFIG);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_MAX_COUNT);
        stringBuilder.append(maxCount.toString());
        stringBuilder.append(URL_SEPARATOR_2);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlModulesOnDevice(String deviceId) throws MalformedURLException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append("devices");
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(deviceId);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_MODULES);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlDeviceList(Integer maxCount) throws MalformedURLException, IllegalArgumentException {
        if (maxCount == null || maxCount < 1) {
            throw new IllegalArgumentException("maxCount cannot be null or less then 1");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append("devices");
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_MAX_COUNT);
        stringBuilder.append(maxCount.toString());
        stringBuilder.append(URL_SEPARATOR_2);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlDeviceStatistics() throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_DEVICESTATISTICS);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append("devices");
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlCreateExportImportJob() throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_JOBS);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append("create");
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlImportExportJob(String jobId) throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(this.hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_JOBS);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(jobId);
        stringBuilder.append(URL_SEPARATOR_1);
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HOST_NAME_PROPERTY_NAME);
        stringBuilder.append(VALUE_PAIR_SEPARATOR);
        stringBuilder.append(this.hostName);
        stringBuilder.append(VALUE_PAIR_DELIMITER);
        stringBuilder.append(SHARED_ACCESS_KEY_NAME_PROPERTY_NAME);
        stringBuilder.append(VALUE_PAIR_SEPARATOR);
        stringBuilder.append(this.sharedAccessKeyName);
        stringBuilder.append(VALUE_PAIR_DELIMITER);
        stringBuilder.append(SHARED_ACCESS_KEY_PROPERTY_NAME);
        stringBuilder.append(VALUE_PAIR_SEPARATOR);
        stringBuilder.append(this.sharedAccessKey);
        stringBuilder.append(VALUE_PAIR_DELIMITER);
        stringBuilder.append(SHARED_ACCESS_SIGNATURE_PROPERTY_NAME);
        stringBuilder.append(VALUE_PAIR_SEPARATOR);
        stringBuilder.append(this.sharedAccessSignature);
        return stringBuilder.toString();
    }

    public String getIotHubName() {
        return this.iotHubName;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public String getSharedAccessKeyName() {
        return this.sharedAccessKeyName;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }

    public String getSharedAccessSignature() {
        return this.sharedAccessSignature;
    }

    public String getHostName() {
        return this.hostName;
    }

    protected void setSharedAccessKeyName(String sharedAccessKeyName) {
        this.sharedAccessKeyName = sharedAccessKeyName;
    }

    protected void setSharedAccessKey(String sharedAccessKey) {
        this.sharedAccessKey = sharedAccessKey;
    }

    protected void setSharedAccessSignature(String sharedAccessSignature) {
        this.sharedAccessSignature = sharedAccessSignature;
    }
}

