/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.service.AuthenticationMethod;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.ServiceAuthenticationWithSharedAccessPolicyKey;
import com.microsoft.azure.sdk.iot.service.ServiceAuthenticationWithSharedAccessPolicyToken;
import com.microsoft.azure.sdk.iot.service.Tools;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class IotHubConnectionStringBuilder {
    private static final String HOST_NAME_REGEX = "[a-zA-Z0-9_\\-\\.]+$";
    private static final String SHARED_ACCESS_KEY_NAME_REGEX = "^[a-zA-Z0-9_\\-@\\.]+$";
    private static final String SHARED_ACCESS_KEY_REGEX = "^.+$";
    private static final String SHARED_ACCESS_SIGNATURE_REGEX = "^.+$";
    private String hostNameSuffix;

    public static IotHubConnectionString createConnectionString(String connectionString) throws IOException {
        if (Tools.isNullOrEmpty(connectionString).booleanValue()) {
            throw new IllegalArgumentException("connection string cannotbe null or empty");
        }
        IotHubConnectionString iotHubConnectionString = new IotHubConnectionString();
        IotHubConnectionStringBuilder.parse(connectionString, iotHubConnectionString);
        return iotHubConnectionString;
    }

    public static IotHubConnectionString createConnectionString(String hostName, AuthenticationMethod authenticationMethod) throws IOException {
        if (Tools.isNullOrEmpty(hostName).booleanValue()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        if (authenticationMethod == null) {
            throw new IllegalArgumentException("authenticationMethod cannot be null");
        }
        IotHubConnectionString iotHubConnectionString = new IotHubConnectionString();
        IotHubConnectionStringBuilder.setHostName(hostName, iotHubConnectionString);
        IotHubConnectionStringBuilder.setAuthenticationMethod(authenticationMethod, iotHubConnectionString);
        IotHubConnectionStringBuilder.validate(iotHubConnectionString);
        return iotHubConnectionString;
    }

    protected static void parse(String connectionString, IotHubConnectionString iotHubConnectionString) throws IOException {
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        if (Tools.isNullOrEmpty(connectionString).booleanValue()) {
            throw new IllegalArgumentException("connectionString cannot be null or empty");
        }
        if (iotHubConnectionString == null) {
            throw new IllegalArgumentException("iotHubConnectionString cannot be null");
        }
        StringTokenizer stringTokenizer1 = new StringTokenizer(connectionString, ";");
        while (stringTokenizer1.hasMoreTokens()) {
            String currentToken = stringTokenizer1.nextToken();
            String[] splitString = currentToken.split("=", 2);
            if (splitString.length != 2) continue;
            keyValueMap.put(splitString[0], splitString[1]);
        }
        iotHubConnectionString.hostName = Tools.getValueStringByKey(keyValueMap, "HostName");
        iotHubConnectionString.sharedAccessKeyName = Tools.getValueStringByKey(keyValueMap, "SharedAccessKeyName");
        iotHubConnectionString.sharedAccessKey = Tools.getValueStringByKey(keyValueMap, "SharedAccessKey");
        iotHubConnectionString.sharedAccessSignature = Tools.getValueStringByKey(keyValueMap, "SharedAccessSignature");
        iotHubConnectionString.iotHubName = IotHubConnectionStringBuilder.parseIotHubName(iotHubConnectionString);
        if (Tools.isNullOrWhiteSpace(iotHubConnectionString.sharedAccessKey).booleanValue()) {
            iotHubConnectionString.authenticationMethod = new ServiceAuthenticationWithSharedAccessPolicyToken(iotHubConnectionString.sharedAccessKeyName, iotHubConnectionString.sharedAccessSignature);
        } else if (Tools.isNullOrWhiteSpace(iotHubConnectionString.sharedAccessSignature).booleanValue()) {
            iotHubConnectionString.authenticationMethod = new ServiceAuthenticationWithSharedAccessPolicyKey(iotHubConnectionString.sharedAccessKeyName, iotHubConnectionString.sharedAccessKey);
        }
        IotHubConnectionStringBuilder.validate(iotHubConnectionString);
    }

    protected static String parseIotHubName(IotHubConnectionString iotHubConnectionString) {
        Integer index = iotHubConnectionString.hostName.indexOf(".");
        if (index >= 0) {
            return iotHubConnectionString.hostName.substring(0, index);
        }
        return "";
    }

    protected static void validate(IotHubConnectionString iotHubConnectionString) throws IllegalArgumentException {
        if (Tools.isNullOrWhiteSpace(iotHubConnectionString.sharedAccessKeyName).booleanValue()) {
            throw new IllegalArgumentException("SharedAccessKeyName cannot be null or empty");
        }
        if (Tools.isNullOrWhiteSpace(iotHubConnectionString.sharedAccessKey).booleanValue() && Tools.isNullOrWhiteSpace(iotHubConnectionString.sharedAccessSignature).booleanValue()) {
            throw new IllegalArgumentException("Should specify either sharedAccessKey or sharedAccessSignature");
        }
        IotHubConnectionStringBuilder.validateFormat(iotHubConnectionString.hostName, "HostName", HOST_NAME_REGEX);
        IotHubConnectionStringBuilder.validateFormatIfSpecified(iotHubConnectionString.sharedAccessKeyName, "SharedAccessKeyName", SHARED_ACCESS_KEY_NAME_REGEX);
        IotHubConnectionStringBuilder.validateFormatIfSpecified(iotHubConnectionString.sharedAccessKey, "SharedAccessKey", "^.+$");
        IotHubConnectionStringBuilder.validateFormatIfSpecified(iotHubConnectionString.sharedAccessSignature, "SharedAccessSignature", "^.+$");
    }

    protected static void validateFormat(String value, String propertyName, String regex) {
        Pattern pattern = Pattern.compile(regex);
        if (!pattern.matcher(value).matches()) {
            throw new IllegalArgumentException("The connection string has an invalid value for property.");
        }
    }

    protected static void validateFormatIfSpecified(String value, String propertyName, String regex) {
        if (!Tools.isNullOrEmpty(value).booleanValue()) {
            IotHubConnectionStringBuilder.validateFormat(value, propertyName, regex);
        }
    }

    protected static void setHostName(String hostName, IotHubConnectionString iotHubConnectionString) {
        IotHubConnectionStringBuilder.validateFormat(hostName, "HostName", HOST_NAME_REGEX);
        iotHubConnectionString.hostName = hostName;
        iotHubConnectionString.iotHubName = IotHubConnectionStringBuilder.parseIotHubName(iotHubConnectionString);
    }

    protected static void setAuthenticationMethod(AuthenticationMethod authenticationMethod, IotHubConnectionString iotHubConnectionString) {
        authenticationMethod.populate(iotHubConnectionString);
        iotHubConnectionString.authenticationMethod = authenticationMethod;
    }
}

