/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.deps.serializer.JobPropertiesParser;
import java.util.Date;

public class JobProperties {
    private String jobId;
    private Date startTimeUtc;
    private Date endTimeUtc;
    private JobType type;
    private JobStatus status;
    private int progress;
    private String inputBlobContainerUri;
    private String outputBlobContainerUri;
    private boolean excludeKeysInExport;
    private String failureReason;

    public JobProperties() {
        this.setJobIdFinal("");
    }

    public String getJobId() {
        return this.jobId;
    }

    @Deprecated
    public void setJobId(String jobId) throws IllegalArgumentException {
        if (jobId == null) {
            throw new IllegalArgumentException("jobId cannot be null");
        }
        this.jobId = jobId;
    }

    public final void setJobIdFinal(String jobId) throws IllegalArgumentException {
        if (jobId == null) {
            throw new IllegalArgumentException("jobId cannot be null");
        }
        this.jobId = jobId;
    }

    public Date getStartTimeUtc() {
        return this.startTimeUtc;
    }

    public void setStartTimeUtc(Date startTimeUtc) {
        this.startTimeUtc = startTimeUtc;
    }

    public Date getEndTimeUtc() {
        return this.endTimeUtc;
    }

    public void setEndTimeUtc(Date endTimeUtc) {
        this.endTimeUtc = endTimeUtc;
    }

    public JobType getType() {
        return this.type;
    }

    public void setType(JobType type) {
        this.type = type;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public void setStatus(JobStatus status) {
        this.status = status;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public String getInputBlobContainerUri() {
        return this.inputBlobContainerUri;
    }

    public void setInputBlobContainerUri(String inputBlobContainerUri) {
        this.inputBlobContainerUri = inputBlobContainerUri;
    }

    public String getOutputBlobContainerUri() {
        return this.outputBlobContainerUri;
    }

    public void setOutputBlobContainerUri(String outputBlobContainerUri) {
        this.outputBlobContainerUri = outputBlobContainerUri;
    }

    public boolean getExcludeKeysInExport() {
        return this.excludeKeysInExport;
    }

    public void setExcludeKeysInExport(boolean excludeKeysInExport) {
        this.excludeKeysInExport = excludeKeysInExport;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    JobProperties(JobPropertiesParser parser) {
        this.endTimeUtc = parser.getEndTimeUtc();
        this.excludeKeysInExport = parser.isExcludeKeysInExport();
        this.failureReason = parser.getFailureReason();
        this.inputBlobContainerUri = parser.getInputBlobContainerUri();
        this.outputBlobContainerUri = parser.getOutputBlobContainerUri();
        this.jobId = parser.getJobIdFinal();
        this.progress = parser.getProgress();
        this.startTimeUtc = parser.getStartTimeUtc();
        if (parser.getStatus() != null) {
            this.status = JobStatus.valueOf(parser.getStatus().toUpperCase());
        }
        if (parser.getType() != null) {
            this.type = JobType.valueOf(parser.getType().toUpperCase());
        }
    }

    JobPropertiesParser toJobPropertiesParser() {
        JobPropertiesParser jobPropertiesParser = new JobPropertiesParser();
        jobPropertiesParser.setEndTimeUtc(this.endTimeUtc);
        jobPropertiesParser.setExcludeKeysInExport(this.excludeKeysInExport);
        jobPropertiesParser.setFailureReason(this.failureReason);
        jobPropertiesParser.setInputBlobContainerUri(this.inputBlobContainerUri);
        jobPropertiesParser.setOutputBlobContainerUri(this.outputBlobContainerUri);
        jobPropertiesParser.setJobId(this.jobId);
        jobPropertiesParser.setProgress(this.progress);
        jobPropertiesParser.setStartTimeUtc(this.startTimeUtc);
        if (this.status != null) {
            jobPropertiesParser.setStatus(this.status.toString());
        }
        if (this.type != null) {
            jobPropertiesParser.setType(this.type.toString().toLowerCase());
        }
        return jobPropertiesParser;
    }

    public static enum JobStatus {
        UNKNOWN,
        ENQUEUED,
        RUNNING,
        COMPLETED,
        FAILED,
        CANCELLED;

    }

    public static enum JobType {
        UNKNOWN,
        EXPORT,
        IMPORT;

    }
}

