/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.deps.serializer.DeviceParser;
import com.microsoft.azure.sdk.iot.service.BaseDevice;
import com.microsoft.azure.sdk.iot.service.Tools;
import com.microsoft.azure.sdk.iot.service.auth.AuthenticationType;
import com.microsoft.azure.sdk.iot.service.auth.SymmetricKey;

public class Module
extends BaseDevice {
    protected String id;
    protected String managedBy;

    public static Module createFromId(String deviceId, String moduleId, SymmetricKey symmetricKey) throws IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("The provided device Id must not be null or empty");
        }
        if (Tools.isNullOrEmpty(moduleId).booleanValue()) {
            throw new IllegalArgumentException("The provided module Id must not be null or empty");
        }
        return new Module(deviceId, moduleId, symmetricKey);
    }

    public static Module createModule(String deviceId, String moduleId, AuthenticationType authenticationType) throws IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("The provided device Id must not be null or empty");
        }
        if (Tools.isNullOrEmpty(moduleId).booleanValue()) {
            throw new IllegalArgumentException("The provided module Id must not be null or empty");
        }
        if (authenticationType == null) {
            throw new IllegalArgumentException("The provided authentication type must not be null");
        }
        return new Module(deviceId, moduleId, authenticationType);
    }

    protected Module(String deviceId, String moduleId, SymmetricKey symmetricKey) throws IllegalArgumentException {
        super(deviceId, symmetricKey);
        if (Tools.isNullOrEmpty(moduleId).booleanValue()) {
            throw new IllegalArgumentException(moduleId);
        }
        this.id = moduleId;
        this.managedBy = "";
    }

    private Module(String deviceId, String moduleId, AuthenticationType authenticationType) {
        super(deviceId, authenticationType);
        if (Tools.isNullOrEmpty(moduleId).booleanValue()) {
            throw new IllegalArgumentException(moduleId);
        }
        this.id = moduleId;
        this.managedBy = "";
    }

    public String getId() {
        return this.id;
    }

    public String getManagedBy() {
        return this.managedBy;
    }

    Module(DeviceParser parser) throws IllegalArgumentException {
        super(parser);
        if (parser.getModuleId() == null) {
            throw new IllegalArgumentException("deviceParser must have a moduleId assigned");
        }
        this.id = parser.getModuleId();
        this.managedBy = parser.getManagedBy();
    }

    @Override
    DeviceParser toDeviceParser() {
        DeviceParser deviceParser = super.toDeviceParser();
        deviceParser.setModuleId(this.id);
        deviceParser.setManagedBy(this.managedBy);
        return deviceParser;
    }
}

