/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.service.FeedbackReceiver;
import com.microsoft.azure.sdk.iot.service.FileUploadNotificationReceiver;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.IotHubServiceClientProtocol;
import com.microsoft.azure.sdk.iot.service.Message;
import com.microsoft.azure.sdk.iot.service.Tools;
import com.microsoft.azure.sdk.iot.service.auth.IotHubServiceSasToken;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.transport.amqps.AmqpSend;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ServiceClient {
    private final ExecutorService executor = Executors.newFixedThreadPool(10);
    private AmqpSend amqpMessageSender;
    private final String hostName;
    private final String userName;
    private final String sasToken;
    protected IotHubConnectionString iotHubConnectionString;
    private IotHubServiceClientProtocol iotHubServiceClientProtocol;

    public static ServiceClient createFromConnectionString(String connectionString, IotHubServiceClientProtocol iotHubServiceClientProtocol) throws IOException {
        if (Tools.isNullOrEmpty(connectionString).booleanValue()) {
            throw new IllegalArgumentException(connectionString);
        }
        IotHubConnectionString iotHubConnectionString = IotHubConnectionStringBuilder.createConnectionString(connectionString);
        ServiceClient iotServiceClient = new ServiceClient(iotHubConnectionString, iotHubServiceClientProtocol);
        return iotServiceClient;
    }

    protected ServiceClient(IotHubConnectionString iotHubConnectionString, IotHubServiceClientProtocol iotHubServiceClientProtocol) {
        if (iotHubConnectionString == null) {
            throw new IllegalArgumentException();
        }
        IotHubServiceSasToken iotHubServiceSasToken = new IotHubServiceSasToken(iotHubConnectionString);
        this.iotHubConnectionString = iotHubConnectionString;
        this.hostName = iotHubConnectionString.getHostName();
        this.userName = iotHubConnectionString.getUserString();
        this.sasToken = iotHubServiceSasToken.toString();
        this.iotHubServiceClientProtocol = iotHubServiceClientProtocol;
        this.amqpMessageSender = new AmqpSend(this.hostName, this.userName, this.sasToken, this.iotHubServiceClientProtocol);
    }

    public void open() throws IOException {
        if (this.amqpMessageSender == null) {
            throw new IOException("AMQP sender is not initialized");
        }
        this.amqpMessageSender.open();
    }

    public void close() throws IOException {
        if (this.amqpMessageSender == null) {
            throw new IOException("AMQP sender is not initialized");
        }
        this.amqpMessageSender.close();
    }

    public void send(String deviceId, Message message) throws IOException, IotHubException {
        this.send(deviceId, null, message);
    }

    public void send(String deviceId, String moduleId, Message message) throws IOException, IotHubException {
        if (this.amqpMessageSender == null) {
            throw new IOException("AMQP sender is not initialized");
        }
        this.amqpMessageSender.send(deviceId, moduleId, message);
    }

    public CompletableFuture<Void> openAsync() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            try {
                this.open();
                future.complete(null);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            try {
                this.close();
                future.complete(null);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Void> sendAsync(String deviceId, Message message) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            try {
                this.send(deviceId, message);
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Deprecated
    public FeedbackReceiver getFeedbackReceiver(String deviceId) {
        FeedbackReceiver feedbackReceiver = new FeedbackReceiver(this.hostName, this.userName, this.sasToken, this.iotHubServiceClientProtocol, deviceId);
        return feedbackReceiver;
    }

    public FeedbackReceiver getFeedbackReceiver() {
        FeedbackReceiver feedbackReceiver = new FeedbackReceiver(this.hostName, this.userName, this.sasToken, this.iotHubServiceClientProtocol);
        return feedbackReceiver;
    }

    public FileUploadNotificationReceiver getFileUploadNotificationReceiver() {
        return new FileUploadNotificationReceiver(this.hostName, this.userName, this.sasToken, this.iotHubServiceClientProtocol);
    }
}

