/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.auth;

import com.microsoft.azure.sdk.iot.service.Tools;
import java.security.SecureRandom;

public class X509Thumbprint {
    private String primaryThumbprint;
    private String secondaryThumbprint;
    private static final String THUMBPRINT_REGEX = "^([A-Fa-f0-9]{2}){20}$";
    private static final String THUMBPRINT_REGEX_DPS = "^([A-Fa-f0-9]{2}){32}$";
    private static final int THUMBPRINT_DIGIT_MAX = 16;
    private static final int THUMBPRINT_LENGTH = 40;

    X509Thumbprint() {
        this.primaryThumbprint = this.generateValidThumbprint();
        this.secondaryThumbprint = this.generateValidThumbprint();
    }

    X509Thumbprint(String primaryThumbprint, String secondaryThumbprint) {
        this.validateThumbprint(primaryThumbprint);
        this.validateThumbprint(secondaryThumbprint);
        this.primaryThumbprint = primaryThumbprint;
        this.secondaryThumbprint = secondaryThumbprint;
    }

    String getPrimaryThumbprint() {
        return this.primaryThumbprint;
    }

    String getSecondaryThumbprint() {
        return this.secondaryThumbprint;
    }

    void setPrimaryThumbprint(String primaryThumbprint) throws IllegalArgumentException {
        this.validateThumbprint(primaryThumbprint);
        this.primaryThumbprint = primaryThumbprint;
    }

    void setSecondaryThumbprint(String secondaryThumbprint) throws IllegalArgumentException {
        this.validateThumbprint(secondaryThumbprint);
        this.secondaryThumbprint = secondaryThumbprint;
    }

    public boolean equals(Object other) {
        if (other instanceof X509Thumbprint) {
            X509Thumbprint otherThumbprint = (X509Thumbprint)other;
            return Tools.areEqual(this.getPrimaryThumbprint(), otherThumbprint.getPrimaryThumbprint()) && Tools.areEqual(this.getSecondaryThumbprint(), otherThumbprint.getSecondaryThumbprint());
        }
        return false;
    }

    private void validateThumbprint(String thumbprint) throws IllegalArgumentException {
        if (thumbprint == null) {
            throw new IllegalArgumentException("Invalid format for primary/secondary thumbprint: thumbprint may not be null");
        }
        if (thumbprint.isEmpty()) {
            throw new IllegalArgumentException("Invalid format for primary/secondary thumbprint: thumbprint may not be empty");
        }
        if (!thumbprint.matches(THUMBPRINT_REGEX) && !thumbprint.matches(THUMBPRINT_REGEX_DPS)) {
            throw new IllegalArgumentException("Invalid format for primary/secondary thumbprint");
        }
    }

    private String generateValidThumbprint() {
        String thumbprint = "";
        SecureRandom rand = new SecureRandom();
        for (int i = 0; i < 40; ++i) {
            thumbprint = thumbprint + Integer.toHexString(rand.nextInt(16));
        }
        return thumbprint;
    }
}

