/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.devicetwin;

import com.microsoft.azure.sdk.iot.deps.twin.ConfigurationInfo;
import com.microsoft.azure.sdk.iot.deps.twin.DeviceCapabilities;
import com.microsoft.azure.sdk.iot.deps.twin.TwinCollection;
import com.microsoft.azure.sdk.iot.deps.util.Tools;
import com.microsoft.azure.sdk.iot.service.devicetwin.Pair;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DeviceTwinDevice {
    private String deviceId = null;
    private String moduleId = null;
    private String eTag = null;
    private Integer version = null;
    private TwinCollection tag = null;
    private TwinCollection reportedProperties = null;
    private TwinCollection desiredProperties = null;
    private Map<String, ConfigurationInfo> configurations = null;
    private DeviceCapabilities capabilities = null;
    private String connectionState;

    public DeviceTwinDevice() {
    }

    public DeviceTwinDevice(String deviceId) throws IllegalArgumentException {
        this();
        if (Tools.isNullOrEmpty((String)deviceId).booleanValue()) {
            throw new IllegalArgumentException("Device ID cannot be null or empty");
        }
        this.deviceId = deviceId;
    }

    public DeviceTwinDevice(String deviceId, String moduleId) throws IllegalArgumentException {
        this();
        if (Tools.isNullOrEmpty((String)deviceId).booleanValue()) {
            throw new IllegalArgumentException("Device ID cannot be null or empty");
        }
        if (Tools.isNullOrEmpty((String)moduleId).booleanValue()) {
            throw new IllegalArgumentException("Module ID cannot be null or empty");
        }
        this.deviceId = deviceId;
        this.moduleId = moduleId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setETag(String eTag) throws IllegalArgumentException {
        if (Tools.isNullOrEmpty((String)eTag).booleanValue()) {
            throw new IllegalArgumentException("ETag cannot be null or empty");
        }
        this.eTag = eTag;
    }

    public String getETag() {
        return this.eTag;
    }

    void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setTags(Set<Pair> tags) throws IllegalArgumentException {
        if (tags == null) {
            throw new IllegalArgumentException("tags cannot be null");
        }
        this.tag = this.setToMap(tags);
    }

    public Set<Pair> getTags() {
        return this.mapToSet(this.tag);
    }

    public void clearTags() {
        this.tag = null;
    }

    public Integer getTagsVersion() {
        if (this.tag == null) {
            throw new IllegalArgumentException("Tags is null");
        }
        return this.tag.getVersionFinal();
    }

    public Set<Pair> getDesiredProperties() {
        return this.mapToSet(this.desiredProperties);
    }

    public void setDesiredProperties(Set<Pair> desiredProperties) throws IllegalArgumentException {
        if (desiredProperties == null) {
            throw new IllegalArgumentException("desiredProperties cannot be null");
        }
        this.desiredProperties = this.setToMap(desiredProperties);
    }

    void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void clearDesiredProperties() {
        this.desiredProperties = null;
    }

    public Integer getDesiredPropertiesVersion() {
        if (this.desiredProperties == null) {
            throw new IllegalArgumentException("Desired properties is null");
        }
        return this.desiredProperties.getVersionFinal();
    }

    public void clearTwin() {
        this.clearTags();
        this.clearDesiredProperties();
    }

    public Set<Pair> getReportedProperties() {
        return this.mapToSet(this.reportedProperties);
    }

    public Integer getReportedPropertiesVersion() {
        if (this.reportedProperties == null) {
            throw new IllegalArgumentException("Reported properties is null");
        }
        return this.reportedProperties.getVersionFinal();
    }

    protected void setReportedProperties(TwinCollection reportedProperties) {
        this.reportedProperties = reportedProperties;
    }

    protected void setDesiredProperties(TwinCollection desiredProperties) {
        this.desiredProperties = desiredProperties;
    }

    protected void setTags(TwinCollection tag) {
        this.tag = tag;
    }

    protected TwinCollection getTagsMap() {
        return this.tag;
    }

    protected TwinCollection getDesiredMap() {
        return this.desiredProperties;
    }

    protected TwinCollection getReportedMap() {
        return this.reportedProperties;
    }

    protected void setConfigurations(Map<String, ConfigurationInfo> configurations) {
        this.configurations = configurations;
    }

    public Map<String, ConfigurationInfo> getConfigurations() {
        return this.configurations;
    }

    protected void setCapabilities(DeviceCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public DeviceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public String getConnectionState() {
        return this.connectionState;
    }

    protected void setConnectionState(String connectionState) {
        this.connectionState = connectionState;
    }

    public String toString() {
        StringBuilder thisDevice = new StringBuilder();
        thisDevice.append("Device ID: " + this.getDeviceId() + "\n");
        if (this.moduleId != null && !this.moduleId.isEmpty()) {
            thisDevice.append("Module ID: " + this.getModuleId() + "\n");
        }
        if (this.getETag() != null) {
            thisDevice.append("ETag: " + this.getETag() + "\n");
        }
        if (this.getVersion() != null) {
            thisDevice.append("Version: " + this.getVersion() + "\n");
        }
        thisDevice.append(this.tagsToString());
        thisDevice.append(this.reportedPropertiesToString());
        thisDevice.append(this.desiredPropertiesToString());
        return thisDevice.toString();
    }

    public String tagsToString() {
        StringBuilder thisDeviceTags = new StringBuilder();
        if (this.tag != null) {
            thisDeviceTags.append("Tags:" + this.tag.toString() + "\n");
        }
        return thisDeviceTags.toString();
    }

    public String desiredPropertiesToString() {
        StringBuilder thisDeviceRepProp = new StringBuilder();
        if (this.desiredProperties != null) {
            thisDeviceRepProp.append("Desired Properties: " + this.desiredProperties.toString() + "\n");
        }
        return thisDeviceRepProp.toString();
    }

    public String reportedPropertiesToString() {
        StringBuilder thisDeviceDesProp = new StringBuilder();
        if (this.reportedProperties != null) {
            thisDeviceDesProp.append("Reported Properties" + this.reportedProperties.toString() + "\n");
        }
        return thisDeviceDesProp.toString();
    }

    private Set<Pair> mapToSet(TwinCollection map) {
        HashSet<Pair> setPair = new HashSet<Pair>();
        if (map != null) {
            for (Map.Entry setEntry : map.entrySet()) {
                setPair.add(new Pair((String)setEntry.getKey(), setEntry.getValue()));
            }
        }
        return setPair;
    }

    private TwinCollection setToMap(Set<Pair> set) {
        TwinCollection map = new TwinCollection();
        if (set != null) {
            for (Pair p : set) {
                if (map.containsKey((Object)p.getKey())) {
                    throw new IllegalArgumentException("Set must not contain multiple pairs with the same keys. Duplicate key: " + p.getKey());
                }
                map.putFinal(p.getKey(), p.getValue());
            }
        }
        return map;
    }
}

