/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.devicetwin;

import com.microsoft.azure.sdk.iot.service.devicetwin.DeviceTwinDevice;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.jobs.JobClient;
import com.microsoft.azure.sdk.iot.service.jobs.JobResult;
import com.microsoft.azure.sdk.iot.service.jobs.JobStatus;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;

public class Job {
    private String jobId;
    private JobClient jobClient;

    Job(String connectionString) throws IOException {
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("Connection string cannot be null or empty");
        }
        this.jobId = "JOB-" + UUID.randomUUID();
        this.jobClient = JobClient.createFromConnectionString(connectionString);
    }

    Job(String jobId, String connectionString) throws IOException {
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("Connection string cannot be null or empty");
        }
        this.jobId = jobId;
        this.jobClient = JobClient.createFromConnectionString(connectionString);
    }

    void scheduleUpdateTwin(String queryCondition, DeviceTwinDevice updateTwin, Date startTimeUtc, long maxExecutionTimeInSeconds) throws IOException, IotHubException {
        if (updateTwin == null) {
            throw new IllegalArgumentException("null updateTwin");
        }
        if (startTimeUtc == null) {
            throw new IllegalArgumentException("null startTimeUtc");
        }
        if (maxExecutionTimeInSeconds < 0L) {
            throw new IllegalArgumentException("negative maxExecutionTimeInSeconds");
        }
        JobResult jobResult = this.jobClient.scheduleUpdateTwin(this.jobId, queryCondition, updateTwin, startTimeUtc, maxExecutionTimeInSeconds);
        if (jobResult.getJobStatus() == JobStatus.failed) {
            throw new IotHubException(jobResult.getStatusMessage() == null ? "Iothub failed to create the job" : jobResult.getStatusMessage());
        }
    }

    void scheduleDeviceMethod(String queryCondition, String methodName, Long responseTimeoutInSeconds, Long connectTimeoutInSeconds, Object payload, Date startTimeUtc, long maxExecutionTimeInSeconds) throws IOException, IotHubException {
        if (methodName == null || methodName.isEmpty()) {
            throw new IllegalArgumentException("null updateTwin");
        }
        if (startTimeUtc == null) {
            throw new IllegalArgumentException("null startTimeUtc");
        }
        if (maxExecutionTimeInSeconds < 0L) {
            throw new IllegalArgumentException("negative maxExecutionTimeInSeconds");
        }
        JobResult jobResult = this.jobClient.scheduleDeviceMethod(this.jobId, queryCondition, methodName, responseTimeoutInSeconds, connectTimeoutInSeconds, payload, startTimeUtc, maxExecutionTimeInSeconds);
        if (jobResult.getJobStatus() == JobStatus.failed) {
            throw new IotHubException(jobResult.getStatusMessage() == null ? "Iothub failed to create the job" : jobResult.getStatusMessage());
        }
    }

    public JobResult get() throws IOException, IotHubException {
        return this.jobClient.getJob(this.jobId);
    }

    public JobResult cancel() throws IOException, IotHubException {
        return this.jobClient.cancelJob(this.jobId);
    }

    public String getJobId() {
        return this.jobId;
    }
}

