/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.devicetwin;

import com.microsoft.azure.sdk.iot.deps.serializer.QueryResponseParser;
import java.util.Collection;

public class QueryCollectionResponse<E> {
    private Collection<E> responseElementsCollection;
    private String continuationToken;

    QueryCollectionResponse(String jsonString, String continuationToken) {
        if (jsonString == null || jsonString.length() == 0) {
            throw new IllegalArgumentException("response cannot be null or empty");
        }
        QueryResponseParser responseParser = new QueryResponseParser(jsonString);
        this.responseElementsCollection = responseParser.getJsonItems();
        this.continuationToken = continuationToken;
    }

    QueryCollectionResponse(Collection<E> responseElementsCollection, String continuationToken) {
        if (responseElementsCollection == null) {
            throw new IllegalArgumentException("Provided Collection must not be null");
        }
        this.responseElementsCollection = responseElementsCollection;
        this.continuationToken = continuationToken;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public Collection<E> getCollection() {
        return this.responseElementsCollection;
    }
}

