/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.microsoft.azure.sdk.iot.deps.serializer.FileUploadNotificationParser;
import com.microsoft.azure.sdk.iot.service.FileUploadNotification;
import com.microsoft.azure.sdk.iot.service.IotHubServiceClientProtocol;
import com.microsoft.azure.sdk.iot.service.transport.amqps.AmqpFeedbackReceivedEvent;
import com.microsoft.azure.sdk.iot.service.transport.amqps.AmqpFileUploadNotificationReceivedHandler;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.reactor.Reactor;

public class AmqpFileUploadNotificationReceive
extends BaseHandler
implements AmqpFeedbackReceivedEvent {
    private final String hostName;
    private final String userName;
    private final String sasToken;
    private AmqpFileUploadNotificationReceivedHandler amqpReceiveHandler;
    private IotHubServiceClientProtocol iotHubServiceClientProtocol;
    private Reactor reactor = null;
    private FileUploadNotification fileUploadNotification;
    private Queue<FileUploadNotification> fileUploadNotificationQueue;
    private static final int REACTOR_TIMEOUT = 3141;

    public AmqpFileUploadNotificationReceive(String hostName, String userName, String sasToken, IotHubServiceClientProtocol iotHubServiceClientProtocol) {
        this.hostName = hostName;
        this.userName = userName;
        this.sasToken = sasToken;
        this.iotHubServiceClientProtocol = iotHubServiceClientProtocol;
    }

    public void onReactorInit(Event event) {
        event.getReactor().connection((Handler)this.amqpReceiveHandler);
    }

    public synchronized void open() throws IOException {
        if (this.amqpReceiveHandler == null) {
            this.amqpReceiveHandler = new AmqpFileUploadNotificationReceivedHandler(this.hostName, this.userName, this.sasToken, this.iotHubServiceClientProtocol, this);
            this.fileUploadNotificationQueue = new LinkedBlockingDeque<FileUploadNotification>();
        }
    }

    public synchronized void close() {
        this.amqpReceiveHandler = null;
        if (this.fileUploadNotificationQueue != null && !this.fileUploadNotificationQueue.isEmpty()) {
            this.fileUploadNotificationQueue.clear();
        }
        this.fileUploadNotificationQueue = null;
    }

    public synchronized FileUploadNotification receive(long timeoutMs) throws IOException, InterruptedException {
        if (this.amqpReceiveHandler != null) {
            this.reactor = Proton.reactor((Handler[])new Handler[]{this});
            this.reactor.setTimeout(3141L);
            this.reactor.start();
            long startTime = System.currentTimeMillis();
            long endTime = startTime + timeoutMs;
            while (this.reactor.process() && System.currentTimeMillis() <= endTime) {
            }
        } else {
            throw new IOException("receive handler is not initialized. call open before receive");
        }
        this.reactor.stop();
        this.reactor.process();
        this.reactor.free();
        this.amqpReceiveHandler.receiveComplete();
        if (!this.fileUploadNotificationQueue.isEmpty()) {
            return this.fileUploadNotificationQueue.remove();
        }
        return null;
    }

    @Override
    public synchronized void onFeedbackReceived(String feedbackJson) {
        try {
            FileUploadNotificationParser notificationParser = new FileUploadNotificationParser(feedbackJson);
            this.fileUploadNotification = new FileUploadNotification(notificationParser.getDeviceId(), notificationParser.getBlobUri(), notificationParser.getBlobName(), notificationParser.getLastUpdatedTime(), notificationParser.getBlobSizeInBytesTag(), notificationParser.getEnqueuedTimeUtc());
            this.fileUploadNotificationQueue.add(this.fileUploadNotification);
        }
        catch (IOException e) {
            this.fileUploadNotification = null;
        }
        catch (Exception e) {
            System.out.println("Service threw something mysteriously dangerous, message abandoned.");
        }
    }
}

