/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.microsoft.azure.sdk.iot.service.IotHubServiceClientProtocol;
import com.microsoft.azure.sdk.iot.service.Message;
import com.microsoft.azure.sdk.iot.service.Tools;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.transport.amqps.AmqpSendHandler;
import java.io.IOException;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.reactor.Reactor;

public class AmqpSend
extends BaseHandler {
    protected final String hostName;
    protected final String userName;
    protected final String sasToken;
    protected Reactor reactor = null;
    protected AmqpSendHandler amqpSendHandler;
    protected IotHubServiceClientProtocol iotHubServiceClientProtocol;

    public AmqpSend(String hostName, String userName, String sasToken, IotHubServiceClientProtocol iotHubServiceClientProtocol) {
        if (Tools.isNullOrEmpty(hostName).booleanValue()) {
            throw new IllegalArgumentException("hostName can not be null or empty");
        }
        if (Tools.isNullOrEmpty(userName).booleanValue()) {
            throw new IllegalArgumentException("userName can not be null or empty");
        }
        if (Tools.isNullOrEmpty(sasToken).booleanValue()) {
            throw new IllegalArgumentException("sasToken can not be null or empty");
        }
        if (iotHubServiceClientProtocol == null) {
            throw new IllegalArgumentException("iotHubServiceClientProtocol cannot be null");
        }
        this.hostName = hostName;
        this.userName = userName;
        this.sasToken = sasToken;
        this.iotHubServiceClientProtocol = iotHubServiceClientProtocol;
    }

    public void onReactorInit(Event event) {
        event.getReactor().connection((Handler)this.amqpSendHandler);
    }

    public void open() {
        this.amqpSendHandler = new AmqpSendHandler(this.hostName, this.userName, this.sasToken, this.iotHubServiceClientProtocol);
    }

    public void close() {
        this.amqpSendHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String deviceId, String moduleId, Message message) throws IOException, IotHubException {
        AmqpSend amqpSend = this;
        synchronized (amqpSend) {
            if (this.amqpSendHandler != null) {
                if (moduleId == null) {
                    this.amqpSendHandler.createProtonMessage(deviceId, message);
                } else {
                    this.amqpSendHandler.createProtonMessage(deviceId, moduleId, message);
                }
            } else {
                throw new IOException("send handler is not initialized. call open before send");
            }
            this.reactor = Proton.reactor((Handler[])new Handler[]{this});
            this.reactor.run();
            this.reactor.free();
            this.amqpSendHandler.sendComplete();
        }
    }
}

