/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.http;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpResponse {
    protected final int status;
    protected final byte[] body;
    protected final byte[] errorReason;
    protected final Map<String, String> headerFields;

    public HttpResponse(int status, byte[] body, Map<String, List<String>> headerFields, byte[] errorReason) {
        this.status = status;
        this.body = Arrays.copyOf(body, body.length);
        this.errorReason = errorReason;
        this.headerFields = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> headerField : headerFields.entrySet()) {
            String key = headerField.getKey();
            if (key == null) continue;
            String field = HttpResponse.canonicalizeFieldName(key);
            String values = HttpResponse.flattenValuesList(headerField.getValue());
            this.headerFields.put(field, values);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getBody() {
        return Arrays.copyOf(this.body, this.body.length);
    }

    public String getHeaderField(String field) {
        String canonicalizedField = HttpResponse.canonicalizeFieldName(field);
        String values = this.headerFields.get(canonicalizedField);
        if (values == null) {
            String errMsg = String.format("Could not find a value associated with the header field name '%s'.\n", field);
            throw new IllegalArgumentException(errMsg);
        }
        return values;
    }

    public Map<String, String> getHeaderFields() {
        HashMap<String, String> headerFieldsCopy = new HashMap<String, String>();
        for (Map.Entry<String, String> field : this.headerFields.entrySet()) {
            headerFieldsCopy.put(field.getKey(), field.getValue());
        }
        return headerFieldsCopy;
    }

    public byte[] getErrorReason() {
        return this.errorReason;
    }

    protected static String canonicalizeFieldName(String field) {
        String canonicalizedField = field;
        if (canonicalizedField != null) {
            canonicalizedField = field.toLowerCase();
        }
        return canonicalizedField;
    }

    protected static String flattenValuesList(List<String> values) {
        String valuesStr = "";
        for (String value : values) {
            valuesStr = valuesStr + value + ",";
        }
        valuesStr = valuesStr.substring(0, Math.max(0, valuesStr.length() - 1));
        return valuesStr;
    }

    protected HttpResponse() {
        this.status = 0;
        this.body = null;
        this.headerFields = null;
        this.errorReason = null;
    }
}

