/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.service.DeviceConnectionState;
import com.microsoft.azure.sdk.iot.service.DeviceStatus;
import com.microsoft.azure.sdk.iot.service.Tools;
import com.microsoft.azure.sdk.iot.service.auth.SymmetricKey;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.KeyGenerator;

public class Device {
    protected final String encryptionMethod = "AES";
    protected final String utcTimeDefault = "0001-01-01T00:00:00";
    protected String deviceId;
    protected String generationId;
    protected transient SymmetricKey symmetricKey;
    @SerializedName(value="etag")
    protected String eTag;
    protected DeviceStatus status;
    protected String statusReason;
    protected String statusUpdatedTime;
    protected DeviceConnectionState connectionState;
    protected String connectionStateUpdatedTime;
    protected String lastActivityTime;
    protected long cloudToDeviceMessageCount;
    private Boolean forceUpdate;

    public static Device createFromId(String deviceId, DeviceStatus status, SymmetricKey symmetricKey) throws IllegalArgumentException, NoSuchAlgorithmException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException(deviceId);
        }
        Device device = new Device(deviceId, status, symmetricKey);
        return device;
    }

    protected Device(String deviceId, DeviceStatus status, SymmetricKey symmetricKey) throws NoSuchAlgorithmException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException();
        }
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        if (symmetricKey == null) {
            symmetricKey = new SymmetricKey();
            Base64.Encoder encoder = Base64.getEncoder();
            symmetricKey.setPrimaryKey(encoder.encodeToString(keyGenerator.generateKey().getEncoded()));
            symmetricKey.setSecondaryKey(encoder.encodeToString(keyGenerator.generateKey().getEncoded()));
        }
        this.symmetricKey = symmetricKey;
        this.deviceId = deviceId;
        this.generationId = "";
        this.eTag = "";
        this.status = status != null ? status : DeviceStatus.Enabled;
        this.statusReason = "";
        this.statusUpdatedTime = "0001-01-01T00:00:00";
        this.connectionState = DeviceConnectionState.Disconnected;
        this.connectionStateUpdatedTime = "0001-01-01T00:00:00";
        this.lastActivityTime = "0001-01-01T00:00:00";
        this.cloudToDeviceMessageCount = 0L;
        this.setForceUpdate(false);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getGenerationId() {
        return this.generationId;
    }

    public SymmetricKey getSymmetricKey() {
        return this.symmetricKey;
    }

    public void setSymmetricKey(SymmetricKey symmetricKey) {
        this.symmetricKey = symmetricKey;
    }

    public String getPrimaryKey() {
        return this.symmetricKey.getPrimaryKey();
    }

    public String getSecondaryKey() {
        return this.symmetricKey.getSecondaryKey();
    }

    public String geteTag() {
        return this.eTag;
    }

    public DeviceStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeviceStatus status) {
        this.status = status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public String getStatusUpdatedTime() {
        return this.statusUpdatedTime;
    }

    public DeviceConnectionState getConnectionState() {
        return this.connectionState;
    }

    public String getConnectionStateUpdatedTime() {
        return this.connectionStateUpdatedTime;
    }

    public String getLastActivityTime() {
        return this.lastActivityTime;
    }

    public long getCloudToDeviceMessageCount() {
        return this.cloudToDeviceMessageCount;
    }

    public void setForceUpdate(Boolean forceUpdate) {
        if (forceUpdate == null) {
            throw new IllegalArgumentException();
        }
        this.forceUpdate = forceUpdate;
    }
}

