/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.microsoft.azure.sdk.iot.service.Device;
import com.microsoft.azure.sdk.iot.service.auth.SymmetricKey;
import java.lang.reflect.Type;

public class DeviceSerializer
implements JsonSerializer<Device> {
    Gson gson = new Gson();

    public JsonElement serialize(Device device, Type type, JsonSerializationContext jsonSerializationContext) {
        Authentication authentication = new Authentication(device.symmetricKey);
        JsonElement authenticationJsonElement = this.gson.toJsonTree((Object)authentication, Authentication.class);
        JsonElement finalJson = this.gson.toJsonTree((Object)device, type);
        finalJson.getAsJsonObject().add("authentication", authenticationJsonElement);
        return finalJson;
    }

    private class Authentication {
        private SymmetricKey symmetricKey;

        public Authentication(SymmetricKey symmetricKey) {
            this.symmetricKey = symmetricKey;
        }
    }
}

