/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.auth;

import com.microsoft.azure.sdk.iot.service.IotHubConnectionString;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public final class IotHubServiceSasToken {
    long TOKEN_VALID_SECS = 31536000L;
    public static final String TOKEN_FORMAT = "SharedAccessSignature sr=%s&sig=%s&se=%s&skn=%s";
    protected final String resourceUri;
    protected final String keyValue;
    protected final long expiryTime;
    protected final String keyName;
    protected final String token;

    public IotHubServiceSasToken(IotHubConnectionString iotHubConnectionString) {
        if (iotHubConnectionString == null) {
            throw new IllegalArgumentException();
        }
        this.resourceUri = iotHubConnectionString.getHostName();
        this.keyValue = iotHubConnectionString.getSharedAccessKey();
        this.keyName = iotHubConnectionString.getSharedAccessKeyName();
        this.expiryTime = this.buildExpiresOn();
        this.token = this.buildToken();
    }

    private String buildToken() {
        try {
            String targetUri = URLEncoder.encode(this.resourceUri.toLowerCase(), String.valueOf(StandardCharsets.UTF_8));
            String toSign = targetUri + "\n" + this.expiryTime;
            byte[] keyBytes = Base64.decodeBase64((byte[])this.keyValue.getBytes("UTF-8"));
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(toSign.getBytes("UTF-8"));
            String signature = URLEncoder.encode(Base64.encodeBase64String((byte[])rawHmac), "UTF-8");
            String token = String.format(TOKEN_FORMAT, targetUri, signature, this.expiryTime, this.keyName);
            return token;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private long buildExpiresOn() {
        long expiresOnDate = System.currentTimeMillis();
        return (expiresOnDate += this.TOKEN_VALID_SECS * 1000L) / 1000L;
    }

    public String toString() {
        return this.token;
    }
}

