/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.devicetwin;

public class Pair {
    private String key;
    private Object value;
    private static final int MAX_ALLOWABLE_KEY_LENGTH = 128;

    public Pair(String key, Object value) throws IllegalArgumentException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        if (key.contains(" ") || key.contains("$") || key.contains(".") || key.length() > 128) {
            throw new IllegalArgumentException("Key cannot contain illegal unicode control characters '.', '$', ' '");
        }
        this.key = key;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public Object setValue(Object value) {
        Object oldValue = this.value;
        this.value = value;
        return oldValue;
    }
}

