/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.devicetwin;

import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.deps.serializer.QueryRequestParser;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.devicetwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.service.devicetwin.QueryResponse;
import com.microsoft.azure.sdk.iot.service.devicetwin.QueryType;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class Query {
    private static final String CONTINUATION_TOKEN_KEY = "x-ms-continuation";
    private static final String ITEM_TYPE_KEY = "x-ms-item-type";
    private static final String PAGE_SIZE_KEY = "x-ms-max-item-count";
    private int pageSize;
    private String query;
    private boolean isSqlQuery;
    private String requestContinuationToken;
    private String responseContinuationToken;
    private QueryType requestQueryType;
    private QueryType responseQueryType;
    private QueryResponse queryResponse;
    private IotHubConnectionString iotHubConnectionString;
    private URL url;
    private HttpMethod httpMethod;
    private long timeout;

    public Query(String query, int pageSize, QueryType requestQueryType) throws IllegalArgumentException {
        ParserUtility.validateQuery((String)query);
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page Size cannot be zero or negative");
        }
        if (requestQueryType == null || requestQueryType == QueryType.UNKNOWN) {
            throw new IllegalArgumentException("Cannot process a unknown type query");
        }
        this.pageSize = pageSize;
        this.query = query;
        this.requestContinuationToken = null;
        this.responseContinuationToken = null;
        this.requestQueryType = requestQueryType;
        this.responseQueryType = QueryType.UNKNOWN;
        this.queryResponse = null;
        this.isSqlQuery = true;
    }

    public Query(int pageSize, QueryType requestQueryType) throws IllegalArgumentException {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page Size cannot be zero or negative");
        }
        if (requestQueryType == null || requestQueryType == QueryType.UNKNOWN) {
            throw new IllegalArgumentException("Cannot process a unknown type query");
        }
        this.pageSize = pageSize;
        this.query = null;
        this.requestContinuationToken = null;
        this.responseContinuationToken = null;
        this.requestQueryType = requestQueryType;
        this.responseQueryType = QueryType.UNKNOWN;
        this.queryResponse = null;
        this.isSqlQuery = false;
    }

    private void continueQuery(String continuationToken) throws IOException, IotHubException {
        this.requestContinuationToken = continuationToken;
        this.sendQueryRequest(this.iotHubConnectionString, this.url, this.httpMethod, this.timeout);
    }

    private void continueQuery(String continuationToken, int pageSize) throws IOException, IotHubException {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page Size cannot be zero or negative");
        }
        this.pageSize = pageSize;
        this.requestContinuationToken = continuationToken;
        this.sendQueryRequest(this.iotHubConnectionString, this.url, this.httpMethod, this.timeout);
    }

    public QueryResponse sendQueryRequest(IotHubConnectionString iotHubConnectionString, URL url, HttpMethod method, Long timeoutInMs) throws IOException, IotHubException {
        if (iotHubConnectionString == null || url == null || method == null) {
            throw new IllegalArgumentException("Input parameters cannot be null");
        }
        this.iotHubConnectionString = iotHubConnectionString;
        this.url = url;
        this.httpMethod = method;
        this.timeout = timeoutInMs;
        byte[] payload = null;
        HashMap<String, String> queryHeaders = new HashMap<String, String>();
        if (this.requestContinuationToken != null) {
            queryHeaders.put(CONTINUATION_TOKEN_KEY, this.requestContinuationToken);
        }
        queryHeaders.put(PAGE_SIZE_KEY, String.valueOf(this.pageSize));
        DeviceOperations.setHeaders(queryHeaders);
        if (this.isSqlQuery) {
            QueryRequestParser requestParser = new QueryRequestParser(this.query);
            payload = requestParser.toJson().getBytes();
        } else {
            payload = new byte[]{};
        }
        HttpResponse httpResponse = DeviceOperations.request(iotHubConnectionString, url, method, payload, null, timeoutInMs);
        this.responseContinuationToken = null;
        Map<String, String> headers = httpResponse.getHeaderFields();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            switch (header.getKey()) {
                case "x-ms-continuation": {
                    this.responseContinuationToken = header.getValue();
                    break;
                }
                case "x-ms-item-type": {
                    this.responseQueryType = QueryType.fromString(header.getValue());
                    break;
                }
            }
        }
        if (this.responseQueryType == null || this.responseQueryType == QueryType.UNKNOWN) {
            throw new IOException("Query response type is not defined by IotHub");
        }
        if (this.requestQueryType != this.responseQueryType) {
            throw new IOException("Query response does not match query request");
        }
        this.queryResponse = new QueryResponse(new String(httpResponse.getBody()));
        return this.queryResponse;
    }

    private String getContinuationToken() {
        return this.responseContinuationToken;
    }

    public boolean hasNext() throws IOException, IotHubException {
        boolean isNextAvailable = this.queryResponse.hasNext();
        if (!isNextAvailable && this.getContinuationToken() != null) {
            this.continueQuery(this.getContinuationToken());
            return this.queryResponse.hasNext();
        }
        return isNextAvailable;
    }

    public Object next() throws IOException, IotHubException, NoSuchElementException {
        if (this.hasNext()) {
            return this.queryResponse.next();
        }
        throw new NoSuchElementException();
    }
}

