/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.devicetwin;

import com.microsoft.azure.sdk.iot.service.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.devicetwin.Query;
import com.microsoft.azure.sdk.iot.service.devicetwin.QueryType;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import java.io.IOException;
import java.util.NoSuchElementException;

public class RawTwinQuery {
    private IotHubConnectionString iotHubConnectionString = null;
    private final long USE_DEFAULT_TIMEOUT = 0L;
    private final int DEFAULT_PAGE_SIZE = 100;

    private RawTwinQuery() {
    }

    public static RawTwinQuery createFromConnectionString(String connectionString) throws IOException {
        if (connectionString == null || connectionString.length() == 0) {
            throw new IllegalArgumentException("Connection string cannot be null or empty");
        }
        RawTwinQuery rawTwinQuery = new RawTwinQuery();
        rawTwinQuery.iotHubConnectionString = IotHubConnectionStringBuilder.createConnectionString(connectionString);
        return rawTwinQuery;
    }

    public synchronized Query query(String sqlQuery, Integer pageSize) throws IotHubException, IOException {
        if (sqlQuery == null || sqlQuery.length() == 0) {
            throw new IllegalArgumentException("Query cannot be null or empty");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pagesize cannot be negative or zero");
        }
        Query rawQuery = new Query(sqlQuery, pageSize, QueryType.RAW);
        rawQuery.sendQueryRequest(this.iotHubConnectionString, this.iotHubConnectionString.getUrlTwinQuery(), HttpMethod.POST, 0L);
        return rawQuery;
    }

    public synchronized Query query(String sqlQuery) throws IotHubException, IOException {
        return this.query(sqlQuery, 100);
    }

    public synchronized boolean hasNext(Query query) throws IotHubException, IOException {
        if (query == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        return query.hasNext();
    }

    public synchronized String next(Query query) throws IOException, IotHubException, NoSuchElementException {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        Object nextObject = query.next();
        if (nextObject instanceof String) {
            return (String)nextObject;
        }
        throw new IOException("Received a response that could not be parsed");
    }
}

