/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.microsoft.azure.sdk.iot.deps.ws.impl.WebSocketImpl;
import com.microsoft.azure.sdk.iot.service.IotHubServiceClientProtocol;
import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.service.transport.amqps.AmqpFeedbackReceivedEvent;
import java.util.HashMap;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Ssl;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.reactor.FlowController;
import org.apache.qpid.proton.reactor.Handshaker;

public class AmqpFeedbackReceivedHandler
extends BaseHandler {
    public static final String RECEIVE_TAG = "receiver";
    public static final String SEND_PORT_AMQPS = ":5671";
    public static final String SEND_PORT_AMQPS_WS = ":443";
    public static final String ENDPOINT = "/messages/servicebound/feedback";
    public static final String WEBSOCKET_PATH = "/$iothub/websocket";
    public static final String WEBSOCKET_SUB_PROTOCOL = "AMQPWSB10";
    private final String hostName;
    private final String userName;
    private final String sasToken;
    protected final IotHubServiceClientProtocol iotHubServiceClientProtocol;
    protected final String webSocketHostName;
    private AmqpFeedbackReceivedEvent amqpFeedbackReceivedEvent;

    public AmqpFeedbackReceivedHandler(String hostName, String userName, String sasToken, IotHubServiceClientProtocol iotHubServiceClientProtocol, AmqpFeedbackReceivedEvent amqpFeedbackReceivedEvent) {
        this.iotHubServiceClientProtocol = iotHubServiceClientProtocol;
        this.webSocketHostName = hostName;
        this.hostName = this.iotHubServiceClientProtocol == IotHubServiceClientProtocol.AMQPS_WS ? hostName + SEND_PORT_AMQPS_WS : hostName + SEND_PORT_AMQPS;
        this.userName = userName;
        this.sasToken = sasToken;
        this.amqpFeedbackReceivedEvent = amqpFeedbackReceivedEvent;
        this.add((Handler)new Handshaker());
        this.add((Handler)new FlowController());
    }

    private SslDomain makeDomain(SslDomain.Mode mode) {
        SslDomain domain = Proton.sslDomain();
        domain.init(mode);
        return domain;
    }

    public void onDelivery(Event event) {
        Receiver recv = (Receiver)event.getLink();
        Delivery delivery = recv.current();
        if (delivery.isReadable() && !delivery.isPartial() && delivery.getLink().getName().equals(RECEIVE_TAG)) {
            int size = delivery.pending();
            byte[] buffer = new byte[size];
            int read = recv.recv(buffer, 0, buffer.length);
            recv.advance();
            Message msg = Proton.message();
            msg.decode(buffer, 0, read);
            delivery.disposition((DeliveryState)Accepted.getInstance());
            delivery.settle();
            recv.getSession().close();
            recv.getSession().getConnection().close();
            if (this.amqpFeedbackReceivedEvent != null) {
                this.amqpFeedbackReceivedEvent.onFeedbackReceived(msg.getBody().toString());
            }
        }
    }

    public void onConnectionBound(Event event) {
        Transport transport = event.getConnection().getTransport();
        if (transport != null) {
            if (this.iotHubServiceClientProtocol == IotHubServiceClientProtocol.AMQPS_WS) {
                WebSocketImpl webSocket = new WebSocketImpl();
                webSocket.configure(this.webSocketHostName, WEBSOCKET_PATH, 0, WEBSOCKET_SUB_PROTOCOL, null, null);
                ((TransportInternal)transport).addTransportLayer((TransportLayer)webSocket);
            }
            Sasl sasl = transport.sasl();
            sasl.plain(this.userName, this.sasToken);
            SslDomain domain = this.makeDomain(SslDomain.Mode.CLIENT);
            domain.setPeerAuthentication(SslDomain.VerifyMode.ANONYMOUS_PEER);
            Ssl ssl = transport.ssl(domain);
        }
    }

    public void onConnectionInit(Event event) {
        Connection conn = event.getConnection();
        conn.setHostname(this.hostName);
        Session ssn = conn.session();
        HashMap<Symbol, String> properties = new HashMap<Symbol, String>();
        properties.put(Symbol.getSymbol((String)"com.microsoft:client-version"), TransportUtils.javaServiceClientIdentifier + TransportUtils.serviceVersion);
        Receiver receiver = ssn.receiver(RECEIVE_TAG);
        receiver.setProperties(properties);
        conn.open();
        ssn.open();
        receiver.open();
    }

    public void onLinkInit(Event event) {
        Link link = event.getLink();
        if (event.getLink().getName().equals(RECEIVE_TAG)) {
            Target t = new Target();
            t.setAddress(ENDPOINT);
            Source source = new Source();
            source.setAddress(ENDPOINT);
            link.setTarget((org.apache.qpid.proton.amqp.transport.Target)t);
            link.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        }
    }
}

