/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.microsoft.azure.sdk.iot.service.exceptions.IotHubDeviceMaximumQueueDepthExceededException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubInvalidOperationException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubNotFoundException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubNotSupportedException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubUnathorizedException;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Received;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;

public class AmqpResponseVerification
implements AmqpError {
    private Symbol errorCondition = null;
    private String errorDescription = null;
    private Map errorInfo = null;
    private IotHubException exception = null;

    public AmqpResponseVerification(DeliveryState state) {
        if (state == null) {
            this.exception = new IotHubException();
        } else if (!state.getClass().equals(Accepted.class)) {
            if (state.getClass().equals(Rejected.class)) {
                Rejected rejectedState = (Rejected)state;
                ErrorCondition errorCond = rejectedState.getError();
                this.errorCondition = errorCond.getCondition();
                this.errorDescription = errorCond.getDescription();
                this.errorInfo = errorCond.getInfo();
                this.amqpResponseVerifier();
            } else if (!(state.getClass().equals(Received.class) || state.getClass().equals(Released.class) || state.getClass().equals(Modified.class))) {
                this.exception = new IotHubException("Unknown delivery state");
            }
        }
    }

    private void amqpResponseVerifier() {
        if (this.errorCondition == null) {
            this.exception = new IotHubException();
        } else if (this.errorCondition.equals(NOT_FOUND)) {
            this.exception = new IotHubNotFoundException(this.errorDescription);
        } else if (this.errorCondition.equals(NOT_IMPLEMENTED)) {
            this.exception = new IotHubNotSupportedException(this.errorDescription);
        } else if (this.errorCondition.equals(NOT_ALLOWED)) {
            this.exception = new IotHubInvalidOperationException(this.errorDescription);
        } else if (this.errorCondition.equals(UNAUTHORIZED_ACCESS)) {
            this.exception = new IotHubUnathorizedException(this.errorDescription);
        } else if (this.errorCondition.equals(RESOURCE_LIMIT_EXCEEDED)) {
            this.exception = new IotHubDeviceMaximumQueueDepthExceededException(this.errorDescription);
        }
    }

    public IotHubException getException() {
        return this.exception;
    }
}

