/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.http;

import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpConnection;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class HttpRequest {
    protected final HttpConnection connection;

    public HttpRequest(URL url, HttpMethod method, byte[] body) throws IOException {
        this.connection = new HttpConnection(url, method);
        this.connection.setRequestHeader("User-Agent", TransportUtils.javaServiceClientIdentifier + TransportUtils.serviceVersion);
        this.connection.writeOutput(body);
    }

    public HttpResponse send() throws IOException {
        Map<String, List<String>> headerFields;
        int responseStatus = -1;
        byte[] responseBody = new byte[]{};
        byte[] errorReason = new byte[]{};
        try {
            this.connection.connect();
            responseStatus = this.connection.getResponseStatus();
            headerFields = this.connection.getResponseHeaders();
            responseBody = this.connection.readInput();
        }
        catch (IOException e) {
            responseStatus = this.connection.getResponseStatus();
            headerFields = this.connection.getResponseHeaders();
            errorReason = this.connection.readError();
        }
        return new HttpResponse(responseStatus, responseBody, headerFields, errorReason);
    }

    public HttpRequest setHeaderField(String field, String value) {
        this.connection.setRequestHeader(field, value);
        return this;
    }

    public HttpRequest setReadTimeoutMillis(int timeout) {
        this.connection.setReadTimeoutMillis(timeout);
        return this;
    }

    protected HttpRequest() {
        this.connection = null;
    }
}

