/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.configurations;

import com.microsoft.azure.sdk.iot.service.ParserUtility;
import com.microsoft.azure.sdk.iot.service.configurations.ConfigurationContent;
import com.microsoft.azure.sdk.iot.service.configurations.ConfigurationMetrics;
import com.microsoft.azure.sdk.iot.service.configurations.serializers.ConfigurationContentParser;
import com.microsoft.azure.sdk.iot.service.configurations.serializers.ConfigurationMetricsParser;
import com.microsoft.azure.sdk.iot.service.configurations.serializers.ConfigurationParser;
import java.util.HashMap;

public class Configuration {
    private static final String UTC_TIME_DEFAULT = "0001-01-01T00:00:00";
    private String id;
    private final String schemaVersion;
    private HashMap<String, String> labels = null;
    private ConfigurationContent content;
    private String targetCondition;
    private String createdTimeUtc;
    private String lastUpdatedTimeUtc;
    private Integer priority;
    private ConfigurationMetrics systemMetrics = null;
    private ConfigurationMetrics metrics = null;
    private String etag;

    public Configuration(String configurationId) {
        this();
        if (configurationId == null || configurationId.isEmpty()) {
            throw new IllegalArgumentException("configuration id cannot be null or empty");
        }
        this.id = configurationId;
    }

    private Configuration() {
        this.schemaVersion = "1.0";
        this.metrics = new ConfigurationMetrics();
        this.etag = "";
        this.lastUpdatedTimeUtc = UTC_TIME_DEFAULT;
        this.createdTimeUtc = UTC_TIME_DEFAULT;
    }

    ConfigurationParser toConfigurationParser() {
        Object parser;
        ConfigurationParser configurationParser = new ConfigurationParser();
        configurationParser.setId(this.id);
        configurationParser.setSchemaVersion(this.schemaVersion);
        configurationParser.setLabels(this.labels);
        configurationParser.setTargetCondition(this.targetCondition);
        configurationParser.setCreatedTimeUtc(ParserUtility.getDateTimeUtc(this.createdTimeUtc));
        configurationParser.setLastUpdatedTimeUtc(ParserUtility.getDateTimeUtc(this.lastUpdatedTimeUtc));
        configurationParser.setPriority(this.priority);
        configurationParser.setETag(this.etag);
        if (this.content != null) {
            parser = new ConfigurationContentParser();
            ((ConfigurationContentParser)parser).setDeviceContent(this.content.getDeviceContent());
            ((ConfigurationContentParser)parser).setModulesContent(this.content.getModulesContent());
            ((ConfigurationContentParser)parser).setModuleContent(this.content.getModuleContent());
            configurationParser.setContent((ConfigurationContentParser)parser);
        }
        if (this.systemMetrics != null) {
            parser = new ConfigurationMetricsParser();
            ((ConfigurationMetricsParser)parser).setQueries(this.systemMetrics.getQueries());
            ((ConfigurationMetricsParser)parser).setResults(this.systemMetrics.getResults());
            configurationParser.setSystemMetrics((ConfigurationMetricsParser)parser);
        }
        if (this.metrics != null) {
            parser = new ConfigurationMetricsParser();
            ((ConfigurationMetricsParser)parser).setQueries(this.metrics.getQueries());
            ((ConfigurationMetricsParser)parser).setResults(this.metrics.getResults());
            configurationParser.setMetrics((ConfigurationMetricsParser)parser);
        }
        return configurationParser;
    }

    Configuration(ConfigurationParser parser) throws IllegalArgumentException {
        if (parser.getId() == null) {
            throw new IllegalArgumentException("configurationParser must have a configurationId assigned");
        }
        this.id = parser.getId();
        this.schemaVersion = parser.getSchemaVersion();
        this.labels = parser.getLabels();
        this.targetCondition = parser.getTargetCondition();
        this.priority = parser.getPriority();
        this.etag = parser.getETag();
        if (parser.getContent() != null) {
            this.content = new ConfigurationContent();
            this.content.deviceContent = parser.getContent().getDeviceContent();
            this.content.modulesContent = parser.getContent().getModulesContent();
        }
        this.createdTimeUtc = parser.getCreatedTimeUtcString();
        this.lastUpdatedTimeUtc = parser.getLastUpdatedTimeUtcString();
        if (parser.getSystemMetrics() != null) {
            this.systemMetrics = new ConfigurationMetrics();
            this.systemMetrics.queries = parser.getSystemMetrics().getQueries();
            this.systemMetrics.results = parser.getSystemMetrics().getResults();
        }
        if (parser.getMetrics() != null) {
            this.metrics = new ConfigurationMetrics();
            this.metrics.queries = parser.getMetrics().getQueries();
            this.metrics.results = parser.getMetrics().getResults();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public HashMap<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(HashMap<String, String> labels) {
        this.labels = labels;
    }

    public ConfigurationContent getContent() {
        return this.content;
    }

    public void setContent(ConfigurationContent content) {
        this.content = content;
    }

    public String getTargetCondition() {
        return this.targetCondition;
    }

    public void setTargetCondition(String targetCondition) {
        this.targetCondition = targetCondition;
    }

    public String getCreatedTimeUtc() {
        return this.createdTimeUtc;
    }

    public String getLastUpdatedTimeUtc() {
        return this.lastUpdatedTimeUtc;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public ConfigurationMetrics getSystemMetrics() {
        return this.systemMetrics;
    }

    public ConfigurationMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(ConfigurationMetrics metrics) {
        this.metrics = metrics;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }
}

