/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.digitaltwin;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.microsoft.azure.sdk.iot.service.ProxyOptions;
import com.microsoft.azure.sdk.iot.service.auth.TokenCredentialCache;
import com.microsoft.azure.sdk.iot.service.digitaltwin.DigitalTwinClientOptions;
import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.BearerTokenProvider;
import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.SasTokenProvider;
import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.ServiceClientBearerTokenCredentialProvider;
import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.ServiceClientCredentialsProvider;
import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.ServiceConnectionString;
import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.ServiceConnectionStringParser;
import com.microsoft.azure.sdk.iot.service.digitaltwin.customized.DigitalTwinGetHeaders;
import com.microsoft.azure.sdk.iot.service.digitaltwin.customized.DigitalTwinUpdateHeaders;
import com.microsoft.azure.sdk.iot.service.digitaltwin.generated.implementation.DigitalTwinsImpl;
import com.microsoft.azure.sdk.iot.service.digitaltwin.generated.implementation.IotHubGatewayServiceAPIsImpl;
import com.microsoft.azure.sdk.iot.service.digitaltwin.helpers.Tools;
import com.microsoft.azure.sdk.iot.service.digitaltwin.models.DigitalTwinCommandResponse;
import com.microsoft.azure.sdk.iot.service.digitaltwin.models.DigitalTwinInvokeCommandHeaders;
import com.microsoft.azure.sdk.iot.service.digitaltwin.models.DigitalTwinInvokeCommandRequestOptions;
import com.microsoft.azure.sdk.iot.service.digitaltwin.models.DigitalTwinUpdateRequestOptions;
import com.microsoft.azure.sdk.iot.service.digitaltwin.serialization.DeserializationHelpers;
import com.microsoft.azure.sdk.iot.service.digitaltwin.serialization.DigitalTwinStringSerializer;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseBuilder;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import com.microsoft.rest.serializer.JacksonAdapter;
import java.net.Proxy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.schedulers.Schedulers;

public class DigitalTwinAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DigitalTwinAsyncClient.class);
    private final DigitalTwinsImpl _protocolLayer;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String HTTPS_SCHEME = "https://";

    public DigitalTwinAsyncClient(String connectionString) {
        this(connectionString, DigitalTwinClientOptions.builder().build());
    }

    public DigitalTwinAsyncClient(String connectionString, DigitalTwinClientOptions options) {
        Objects.requireNonNull(options);
        ServiceConnectionString serviceConnectionString = ServiceConnectionStringParser.parseConnectionString(connectionString);
        SasTokenProvider sasTokenProvider = serviceConnectionString.createSasTokenProvider();
        String httpsEndpoint = serviceConnectionString.getHttpsEndpoint();
        SimpleModule stringModule = new SimpleModule("String Serializer");
        stringModule.addSerializer((JsonSerializer)new DigitalTwinStringSerializer(String.class, objectMapper));
        JacksonAdapter adapter = new JacksonAdapter();
        adapter.serializer().registerModule((Module)stringModule);
        ProxyOptions proxyOptions = options.getProxyOptions();
        Proxy proxy = null;
        if (proxyOptions != null) {
            proxy = proxyOptions.getProxy();
        }
        RestClient simpleRestClient = new RestClient.Builder().withConnectionTimeout((long)options.getHttpConnectTimeoutSeconds(), TimeUnit.SECONDS).withReadTimeout((long)options.getHttpReadTimeoutSeconds(), TimeUnit.SECONDS).withProxy(proxy).withBaseUrl(httpsEndpoint).withCredentials((ServiceClientCredentials)new ServiceClientCredentialsProvider(sasTokenProvider)).withResponseBuilderFactory((ResponseBuilder.Factory)new ServiceResponseBuilder.Factory()).withSerializerAdapter((SerializerAdapter)adapter).build();
        IotHubGatewayServiceAPIsImpl protocolLayerClient = new IotHubGatewayServiceAPIsImpl(simpleRestClient);
        this._protocolLayer = new DigitalTwinsImpl(simpleRestClient.retrofit(), protocolLayerClient);
        DigitalTwinAsyncClient.commonConstructorSetup();
    }

    public DigitalTwinAsyncClient(String hostName, TokenCredential credential) {
        this(hostName, credential, DigitalTwinClientOptions.builder().build());
    }

    public DigitalTwinAsyncClient(String hostName, TokenCredential credential, DigitalTwinClientOptions options) {
        Objects.requireNonNull(options);
        SimpleModule stringModule = new SimpleModule("String Serializer");
        stringModule.addSerializer((JsonSerializer)new DigitalTwinStringSerializer(String.class, objectMapper));
        TokenCredentialCache tokenCredentialCache = new TokenCredentialCache(credential);
        BearerTokenProvider bearerTokenProvider = () -> tokenCredentialCache.getTokenString();
        JacksonAdapter adapter = new JacksonAdapter();
        adapter.serializer().registerModule((Module)stringModule);
        ProxyOptions proxyOptions = options.getProxyOptions();
        Proxy proxy = null;
        if (proxyOptions != null) {
            proxy = proxyOptions.getProxy();
        }
        RestClient simpleRestClient = new RestClient.Builder().withBaseUrl(HTTPS_SCHEME + hostName).withConnectionTimeout((long)options.getHttpConnectTimeoutSeconds(), TimeUnit.SECONDS).withReadTimeout((long)options.getHttpReadTimeoutSeconds(), TimeUnit.SECONDS).withProxy(proxy).withCredentials((ServiceClientCredentials)new ServiceClientBearerTokenCredentialProvider(bearerTokenProvider)).withResponseBuilderFactory((ResponseBuilder.Factory)new ServiceResponseBuilder.Factory()).withSerializerAdapter((SerializerAdapter)adapter).build();
        IotHubGatewayServiceAPIsImpl protocolLayerClient = new IotHubGatewayServiceAPIsImpl(simpleRestClient);
        this._protocolLayer = new DigitalTwinsImpl(simpleRestClient.retrofit(), protocolLayerClient);
        DigitalTwinAsyncClient.commonConstructorSetup();
    }

    public DigitalTwinAsyncClient(String hostName, AzureSasCredential azureSasCredential) {
        this(hostName, azureSasCredential, DigitalTwinClientOptions.builder().build());
    }

    public DigitalTwinAsyncClient(String hostName, AzureSasCredential azureSasCredential, DigitalTwinClientOptions options) {
        Objects.requireNonNull(options);
        SimpleModule stringModule = new SimpleModule("String Serializer");
        stringModule.addSerializer((JsonSerializer)new DigitalTwinStringSerializer(String.class, objectMapper));
        SasTokenProvider sasTokenProvider = () -> ((AzureSasCredential)azureSasCredential).getSignature();
        JacksonAdapter adapter = new JacksonAdapter();
        adapter.serializer().registerModule((Module)stringModule);
        ProxyOptions proxyOptions = options.getProxyOptions();
        Proxy proxy = null;
        if (proxyOptions != null) {
            proxy = proxyOptions.getProxy();
        }
        RestClient simpleRestClient = new RestClient.Builder().withBaseUrl(HTTPS_SCHEME + hostName).withConnectionTimeout((long)options.getHttpConnectTimeoutSeconds(), TimeUnit.SECONDS).withReadTimeout((long)options.getHttpReadTimeoutSeconds(), TimeUnit.SECONDS).withProxy(proxy).withCredentials((ServiceClientCredentials)new ServiceClientCredentialsProvider(sasTokenProvider)).withResponseBuilderFactory((ResponseBuilder.Factory)new ServiceResponseBuilder.Factory()).withSerializerAdapter((SerializerAdapter)adapter).build();
        IotHubGatewayServiceAPIsImpl protocolLayerClient = new IotHubGatewayServiceAPIsImpl(simpleRestClient);
        this._protocolLayer = new DigitalTwinsImpl(simpleRestClient.retrofit(), protocolLayerClient);
        DigitalTwinAsyncClient.commonConstructorSetup();
    }

    public static DigitalTwinAsyncClient createFromConnectionString(String connectionString) {
        return new DigitalTwinAsyncClient(connectionString);
    }

    private static void commonConstructorSetup() {
        log.debug("Initialized a digital twin client instance using SDK version {}", (Object)TransportUtils.serviceVersion);
    }

    public <T> Observable<T> getDigitalTwin(String digitalTwinId, Class<T> clazz) {
        return this.getDigitalTwinWithResponse(digitalTwinId, clazz).map(ServiceResponse::body);
    }

    public <T> Observable<ServiceResponseWithHeaders<T, DigitalTwinGetHeaders>> getDigitalTwinWithResponse(String digitalTwinId, Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz is required and cannot be null.");
        }
        return this._protocolLayer.getDigitalTwinWithServiceResponseAsync(digitalTwinId).flatMap(Tools.FUNC_TO_DIGITAL_TWIN_GET_RESPONSE).flatMap(response -> {
            try {
                Object genericResponse = DeserializationHelpers.castObject(objectMapper, response.body(), clazz);
                return Observable.just((Object)new ServiceResponseWithHeaders(genericResponse, response.headers(), response.response()));
            }
            catch (JsonProcessingException e) {
                return Observable.error((Throwable)new IotHubException("Failed to parse the resonse"));
            }
        }).subscribeOn(Schedulers.io());
    }

    public Observable<Void> updateDigitalTwin(String digitalTwinId, List<Object> digitalTwinUpdateOperations) {
        return this.updateDigitalTwinWithResponse(digitalTwinId, digitalTwinUpdateOperations, null).map(ServiceResponse::body);
    }

    public Observable<ServiceResponseWithHeaders<Void, DigitalTwinUpdateHeaders>> updateDigitalTwinWithResponse(String digitalTwinId, List<Object> digitalTwinUpdateOperations) {
        return this.updateDigitalTwinWithResponse(digitalTwinId, digitalTwinUpdateOperations, null);
    }

    public Observable<ServiceResponseWithHeaders<Void, DigitalTwinUpdateHeaders>> updateDigitalTwinWithResponse(String digitalTwinId, List<Object> digitalTwinUpdateOperations, DigitalTwinUpdateRequestOptions options) {
        String ifMatch = options != null ? options.getIfMatch() : null;
        return this._protocolLayer.updateDigitalTwinWithServiceResponseAsync(digitalTwinId, digitalTwinUpdateOperations, ifMatch).flatMap(Tools.FUNC_TO_DIGITAL_TWIN_UPDATE_RESPONSE).subscribeOn(Schedulers.io());
    }

    public Observable<DigitalTwinCommandResponse> invokeCommand(String digitalTwinId, String commandName) {
        return this.invokeCommandWithResponse(digitalTwinId, commandName, null, null).map(ServiceResponse::body);
    }

    public Observable<DigitalTwinCommandResponse> invokeCommand(String digitalTwinId, String commandName, String payload) {
        return this.invokeCommandWithResponse(digitalTwinId, commandName, payload, null).map(ServiceResponse::body);
    }

    public Observable<ServiceResponseWithHeaders<DigitalTwinCommandResponse, DigitalTwinInvokeCommandHeaders>> invokeCommandWithResponse(String digitalTwinId, String commandName, String payload, DigitalTwinInvokeCommandRequestOptions options) {
        if (options == null) {
            options = new DigitalTwinInvokeCommandRequestOptions();
        }
        if (payload == null) {
            payload = "";
        }
        return this._protocolLayer.invokeRootLevelCommandWithServiceResponseAsync(digitalTwinId, commandName, payload, options.getConnectTimeoutInSeconds(), options.getResponseTimeoutInSeconds()).flatMap(Tools.FUNC_TO_DIGITAL_TWIN_COMMAND_RESPONSE);
    }

    public Observable<DigitalTwinCommandResponse> invokeComponentCommand(String digitalTwinId, String componentName, String commandName) {
        return this.invokeComponentCommandWithResponse(digitalTwinId, componentName, commandName, null, null).map(ServiceResponse::body);
    }

    public Observable<DigitalTwinCommandResponse> invokeComponentCommand(String digitalTwinId, String componentName, String commandName, String payload) {
        return this.invokeComponentCommandWithResponse(digitalTwinId, componentName, commandName, payload, null).map(ServiceResponse::body);
    }

    public Observable<ServiceResponseWithHeaders<DigitalTwinCommandResponse, DigitalTwinInvokeCommandHeaders>> invokeComponentCommandWithResponse(String digitalTwinId, String componentName, String commandName, String payload, DigitalTwinInvokeCommandRequestOptions options) {
        if (options == null) {
            options = new DigitalTwinInvokeCommandRequestOptions();
        }
        if (payload == null) {
            payload = "";
        }
        return this._protocolLayer.invokeComponentCommandWithServiceResponseAsync(digitalTwinId, componentName, commandName, payload, options.getConnectTimeoutInSeconds(), options.getResponseTimeoutInSeconds()).flatMap(Tools.FUNC_TO_DIGITAL_TWIN_COMPONENT_COMMAND_RESPONSE);
    }
}

