/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.digitaltwin;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.sdk.iot.service.digitaltwin.DigitalTwinAsyncClient;
import com.microsoft.azure.sdk.iot.service.digitaltwin.DigitalTwinClientOptions;
import com.microsoft.azure.sdk.iot.service.digitaltwin.customized.DigitalTwinGetHeaders;
import com.microsoft.azure.sdk.iot.service.digitaltwin.customized.DigitalTwinUpdateHeaders;
import com.microsoft.azure.sdk.iot.service.digitaltwin.models.DigitalTwinCommandResponse;
import com.microsoft.azure.sdk.iot.service.digitaltwin.models.DigitalTwinInvokeCommandHeaders;
import com.microsoft.azure.sdk.iot.service.digitaltwin.models.DigitalTwinInvokeCommandRequestOptions;
import com.microsoft.azure.sdk.iot.service.digitaltwin.models.DigitalTwinUpdateRequestOptions;
import com.microsoft.rest.ServiceResponseWithHeaders;
import java.util.List;

public class DigitalTwinClient {
    private final DigitalTwinAsyncClient digitalTwinAsyncClient;

    public DigitalTwinClient(String connectionString) {
        this(connectionString, DigitalTwinClientOptions.builder().build());
    }

    public DigitalTwinClient(String connectionString, DigitalTwinClientOptions options) {
        this.digitalTwinAsyncClient = new DigitalTwinAsyncClient(connectionString, options);
    }

    public DigitalTwinClient(String hostName, TokenCredential credential) {
        this(hostName, credential, DigitalTwinClientOptions.builder().build());
    }

    public DigitalTwinClient(String hostName, TokenCredential credential, DigitalTwinClientOptions options) {
        this.digitalTwinAsyncClient = new DigitalTwinAsyncClient(hostName, credential, options);
    }

    public DigitalTwinClient(String hostName, AzureSasCredential azureSasCredential) {
        this(hostName, azureSasCredential, DigitalTwinClientOptions.builder().build());
    }

    public DigitalTwinClient(String hostName, AzureSasCredential azureSasCredential, DigitalTwinClientOptions options) {
        this.digitalTwinAsyncClient = new DigitalTwinAsyncClient(hostName, azureSasCredential, options);
    }

    public static DigitalTwinClient createFromConnectionString(String connectionString) {
        return new DigitalTwinClient(connectionString);
    }

    public <T> T getDigitalTwin(String digitalTwinId, Class<T> clazz) {
        return (T)this.getDigitalTwinWithResponse(digitalTwinId, clazz).body();
    }

    public <T> ServiceResponseWithHeaders<T, DigitalTwinGetHeaders> getDigitalTwinWithResponse(String digitalTwinId, Class<T> clazz) {
        return (ServiceResponseWithHeaders)this.digitalTwinAsyncClient.getDigitalTwinWithResponse(digitalTwinId, clazz).toBlocking().single();
    }

    public Void updateDigitalTwin(String digitalTwinId, List<Object> digitalTwinUpdateOperations) {
        return (Void)this.digitalTwinAsyncClient.updateDigitalTwin(digitalTwinId, digitalTwinUpdateOperations).toBlocking().single();
    }

    public ServiceResponseWithHeaders<Void, DigitalTwinUpdateHeaders> updateDigitalTwinWithResponse(String digitalTwinId, List<Object> digitalTwinUpdateOperations) {
        return this.updateDigitalTwinWithResponse(digitalTwinId, digitalTwinUpdateOperations, null);
    }

    public ServiceResponseWithHeaders<Void, DigitalTwinUpdateHeaders> updateDigitalTwinWithResponse(String digitalTwinId, List<Object> digitalTwinUpdateOperations, DigitalTwinUpdateRequestOptions options) {
        return (ServiceResponseWithHeaders)this.digitalTwinAsyncClient.updateDigitalTwinWithResponse(digitalTwinId, digitalTwinUpdateOperations, options).toBlocking().single();
    }

    public DigitalTwinCommandResponse invokeCommand(String digitalTwinId, String commandName) {
        return (DigitalTwinCommandResponse)this.invokeCommandWithResponse(digitalTwinId, commandName, null, null).body();
    }

    public DigitalTwinCommandResponse invokeCommand(String digitalTwinId, String commandName, String payload) {
        return (DigitalTwinCommandResponse)this.invokeCommandWithResponse(digitalTwinId, commandName, payload, null).body();
    }

    public ServiceResponseWithHeaders<DigitalTwinCommandResponse, DigitalTwinInvokeCommandHeaders> invokeCommandWithResponse(String digitalTwinId, String commandName, String payload, DigitalTwinInvokeCommandRequestOptions options) {
        return (ServiceResponseWithHeaders)this.digitalTwinAsyncClient.invokeCommandWithResponse(digitalTwinId, commandName, payload, options).toBlocking().single();
    }

    public DigitalTwinCommandResponse invokeComponentCommand(String digitalTwinId, String componentName, String commandName) {
        return (DigitalTwinCommandResponse)this.invokeComponentCommandWithResponse(digitalTwinId, componentName, commandName, null, null).body();
    }

    public DigitalTwinCommandResponse invokeComponentCommand(String digitalTwinId, String componentName, String commandName, String payload) {
        return (DigitalTwinCommandResponse)this.invokeComponentCommandWithResponse(digitalTwinId, componentName, commandName, payload, null).body();
    }

    public ServiceResponseWithHeaders<DigitalTwinCommandResponse, DigitalTwinInvokeCommandHeaders> invokeComponentCommandWithResponse(String digitalTwinId, String componentName, String commandName, String payload, DigitalTwinInvokeCommandRequestOptions options) {
        return (ServiceResponseWithHeaders)this.digitalTwinAsyncClient.invokeComponentCommandWithResponse(digitalTwinId, componentName, commandName, payload, options).toBlocking().single();
    }
}

