/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.digitaltwin;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class UpdateOperationUtility {
    private static final String ADD = "add";
    private static final String REPLACE = "replace";
    private static final String REMOVE = "remove";
    private static final ObjectMapper mapper = new ObjectMapper();
    private final List<UpdateOperation> operations = new ArrayList<UpdateOperation>();

    public List<Object> getUpdateOperations() {
        return this.operations.stream().map(op -> mapper.convertValue(op, Object.class)).collect(Collectors.toList());
    }

    public UpdateOperationUtility appendAddPropertyOperation(String path, Object value) {
        this.operations.add(new UpdateOperation().setOperation(ADD).setPath(path).setValue(value));
        return this;
    }

    public UpdateOperationUtility appendAddComponentOperation(String path, Map<String, Object> properties) {
        properties.put("$metadata", Collections.emptyMap());
        this.operations.add(new UpdateOperation().setOperation(ADD).setPath(path).setValue(properties));
        return this;
    }

    public UpdateOperationUtility appendReplacePropertyOperation(String path, Object value) {
        this.operations.add(new UpdateOperation().setOperation(REPLACE).setPath(path).setValue(value));
        return this;
    }

    public UpdateOperationUtility appendReplaceComponentOperation(String path, Map<String, Object> properties) {
        properties.put("$metadata", Collections.emptyMap());
        this.operations.add(new UpdateOperation().setOperation(REPLACE).setPath(path).setValue(properties));
        return this;
    }

    public UpdateOperationUtility appendRemovePropertyOperation(String path) {
        this.operations.add(new UpdateOperation().setOperation(REMOVE).setPath(path));
        return this;
    }

    public UpdateOperationUtility appendRemoveComponentOperation(String path) {
        this.appendRemovePropertyOperation(path);
        return this;
    }

    static class UpdateOperation {
        @JsonProperty(value="op")
        private String operation;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="value")
        private Object value;

        UpdateOperation() {
        }

        String getOperation() {
            return this.operation;
        }

        UpdateOperation setOperation(String operation) {
            this.operation = operation;
            return this;
        }

        String getPath() {
            return this.path;
        }

        UpdateOperation setPath(String path) {
            this.path = path;
            return this;
        }

        Object getValue() {
            return this.value;
        }

        UpdateOperation setValue(Object value) {
            this.value = value;
            return this;
        }
    }
}

