/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.digitaltwin.authentication;

import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.BearerTokenProvider;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class ServiceClientBearerTokenCredentialProvider
implements ServiceClientCredentials {
    private static final String AUTHORIZATION = "Authorization";
    @NonNull
    private final BearerTokenProvider tokenProvider;

    public void applyCredentialsFilter(OkHttpClient.Builder clientBuilder) {
        Interceptor authenticationInterceptor = chain -> {
            String authorizationValue = this.tokenProvider.getBearerToken();
            Request authenticatedRequest = chain.request().newBuilder().header(AUTHORIZATION, authorizationValue).build();
            return chain.proceed(authenticatedRequest);
        };
        clientBuilder.interceptors().add(authenticationInterceptor);
    }

    public ServiceClientBearerTokenCredentialProvider(@NonNull BearerTokenProvider tokenProvider) {
        if (tokenProvider == null) {
            throw new NullPointerException("tokenProvider is marked non-null but is null");
        }
        this.tokenProvider = tokenProvider;
    }
}

