/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.digitaltwin.authentication;

import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.SasTokenProvider;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class ServiceClientCredentialsProvider
implements ServiceClientCredentials {
    private static final String AUTHORIZATION = "Authorization";
    @NonNull
    private final SasTokenProvider sasTokenProvider;

    public void applyCredentialsFilter(OkHttpClient.Builder clientBuilder) {
        Interceptor authenticationInterceptor = chain -> {
            Request authenticatedRequest = chain.request().newBuilder().header(AUTHORIZATION, this.sasTokenProvider.getSasToken()).build();
            return chain.proceed(authenticatedRequest);
        };
        clientBuilder.interceptors().add(authenticationInterceptor);
    }

    public ServiceClientCredentialsProvider(@NonNull SasTokenProvider sasTokenProvider) {
        if (sasTokenProvider == null) {
            throw new NullPointerException("sasTokenProvider is marked non-null but is null");
        }
        this.sasTokenProvider = sasTokenProvider;
    }
}

