/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.digitaltwin.authentication;

import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.SasTokenProvider;
import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.SasTokenProviderWithSharedAccessKey;
import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.StaticSasTokenProvider;
import lombok.NonNull;

public class ServiceConnectionString {
    private static final String HOST_NAME_REGEX = "[a-zA-Z0-9_\\-\\.]+$";
    private static final String SHARED_ACCESS_KEY_NAME_REGEX = "^[a-zA-Z0-9_\\-@\\.]+$";
    private static final String SHARED_ACCESS_KEY_REGEX = "^.+$";
    private static final String SHARED_ACCESS_SIGNATURE_REGEX = "^.+$";
    private final String hostName;
    private final String httpsEndpoint;
    private final String sharedAccessKeyName;
    private final String sharedAccessKey;
    private final String sharedAccessSignature;

    ServiceConnectionString(@NonNull String hostName, @NonNull String httpsEndpoint, String sharedAccessKeyName, String sharedAccessKey, String sharedAccessSignature) {
        if (hostName == null) {
            throw new NullPointerException("hostName is marked non-null but is null");
        }
        if (httpsEndpoint == null) {
            throw new NullPointerException("httpsEndpoint is marked non-null but is null");
        }
        if (!this.validInput(sharedAccessKeyName, sharedAccessKey, sharedAccessSignature)) {
            throw new IllegalArgumentException("Specify either both the sharedAccessKey and sharedAccessKeyName, or sharedAccessSignature");
        }
        this.hostName = hostName;
        this.httpsEndpoint = httpsEndpoint;
        this.sharedAccessKeyName = sharedAccessKeyName;
        this.sharedAccessKey = sharedAccessKey;
        this.sharedAccessSignature = sharedAccessSignature;
    }

    public SasTokenProvider createSasTokenProvider() {
        if (this.sharedAccessSignature != null) {
            return new StaticSasTokenProvider(this.sharedAccessSignature);
        }
        return SasTokenProviderWithSharedAccessKey.builder().hostName(this.hostName).sharedAccessKeyName(this.sharedAccessKeyName).sharedAccessKey(this.sharedAccessKey).build();
    }

    private boolean validInput(String sharedAccessKeyName, String sharedAccessKey, String sharedAccessSignature) {
        if (sharedAccessSignature == null) {
            return sharedAccessKey != null && sharedAccessKeyName != null;
        }
        return sharedAccessKey == null && sharedAccessKeyName == null;
    }

    public static ServiceConnectionStringBuilder builder() {
        return new ServiceConnectionStringBuilder();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHttpsEndpoint() {
        return this.httpsEndpoint;
    }

    public String getSharedAccessKeyName() {
        return this.sharedAccessKeyName;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }

    public String getSharedAccessSignature() {
        return this.sharedAccessSignature;
    }

    public static class ServiceConnectionStringBuilder {
        private String hostName;
        private String httpsEndpoint;
        private String sharedAccessKeyName;
        private String sharedAccessKey;
        private String sharedAccessSignature;

        ServiceConnectionStringBuilder() {
        }

        public ServiceConnectionStringBuilder hostName(@NonNull String hostName) {
            if (hostName == null) {
                throw new NullPointerException("hostName is marked non-null but is null");
            }
            this.hostName = hostName;
            return this;
        }

        public ServiceConnectionStringBuilder httpsEndpoint(@NonNull String httpsEndpoint) {
            if (httpsEndpoint == null) {
                throw new NullPointerException("httpsEndpoint is marked non-null but is null");
            }
            this.httpsEndpoint = httpsEndpoint;
            return this;
        }

        public ServiceConnectionStringBuilder sharedAccessKeyName(String sharedAccessKeyName) {
            this.sharedAccessKeyName = sharedAccessKeyName;
            return this;
        }

        public ServiceConnectionStringBuilder sharedAccessKey(String sharedAccessKey) {
            this.sharedAccessKey = sharedAccessKey;
            return this;
        }

        public ServiceConnectionStringBuilder sharedAccessSignature(String sharedAccessSignature) {
            this.sharedAccessSignature = sharedAccessSignature;
            return this;
        }

        public ServiceConnectionString build() {
            return new ServiceConnectionString(this.hostName, this.httpsEndpoint, this.sharedAccessKeyName, this.sharedAccessKey, this.sharedAccessSignature);
        }

        public String toString() {
            return "ServiceConnectionString.ServiceConnectionStringBuilder(hostName=" + this.hostName + ", httpsEndpoint=" + this.httpsEndpoint + ", sharedAccessKeyName=" + this.sharedAccessKeyName + ", sharedAccessKey=" + this.sharedAccessKey + ", sharedAccessSignature=" + this.sharedAccessSignature + ")";
        }
    }
}

