/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.digitaltwin.generated.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.sdk.iot.service.digitaltwin.generated.DigitalTwins;
import com.microsoft.azure.sdk.iot.service.digitaltwin.generated.implementation.IotHubGatewayServiceAPIsImpl;
import com.microsoft.azure.sdk.iot.service.digitaltwin.generated.models.DigitalTwinGetDigitalTwinHeaders;
import com.microsoft.azure.sdk.iot.service.digitaltwin.generated.models.DigitalTwinInvokeComponentCommandHeaders;
import com.microsoft.azure.sdk.iot.service.digitaltwin.generated.models.DigitalTwinInvokeRootLevelCommandHeaders;
import com.microsoft.azure.sdk.iot.service.digitaltwin.generated.models.DigitalTwinUpdateDigitalTwinHeaders;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DigitalTwinsImpl
implements DigitalTwins {
    private final DigitalTwinsService service;
    private final IotHubGatewayServiceAPIsImpl client;

    public DigitalTwinsImpl(Retrofit retrofit, IotHubGatewayServiceAPIsImpl client) {
        this.service = (DigitalTwinsService)retrofit.create(DigitalTwinsService.class);
        this.client = client;
    }

    @Override
    public Object getDigitalTwin(String id) {
        return ((ServiceResponseWithHeaders)this.getDigitalTwinWithServiceResponseAsync(id).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> getDigitalTwinAsync(String id, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getDigitalTwinWithServiceResponseAsync(id), serviceCallback);
    }

    @Override
    public Observable<Object> getDigitalTwinAsync(String id) {
        return this.getDigitalTwinWithServiceResponseAsync(id).map((Func1)new Func1<ServiceResponseWithHeaders<Object, DigitalTwinGetDigitalTwinHeaders>, Object>(){

            public Object call(ServiceResponseWithHeaders<Object, DigitalTwinGetDigitalTwinHeaders> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Object, DigitalTwinGetDigitalTwinHeaders>> getDigitalTwinWithServiceResponseAsync(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter id is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.getDigitalTwin(id, "2020-09-30").flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Object, DigitalTwinGetDigitalTwinHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Object, DigitalTwinGetDigitalTwinHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = DigitalTwinsImpl.this.getDigitalTwinDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Object, DigitalTwinGetDigitalTwinHeaders> getDigitalTwinDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Object>(){}.getType()).buildWithHeaders(response, DigitalTwinGetDigitalTwinHeaders.class);
    }

    @Override
    public void updateDigitalTwin(String id, List<Object> digitalTwinPatch) {
        ((ServiceResponseWithHeaders)this.updateDigitalTwinWithServiceResponseAsync(id, digitalTwinPatch).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateDigitalTwinAsync(String id, List<Object> digitalTwinPatch, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateDigitalTwinWithServiceResponseAsync(id, digitalTwinPatch), serviceCallback);
    }

    @Override
    public Observable<Void> updateDigitalTwinAsync(String id, List<Object> digitalTwinPatch) {
        return this.updateDigitalTwinWithServiceResponseAsync(id, digitalTwinPatch).map((Func1)new Func1<ServiceResponseWithHeaders<Void, DigitalTwinUpdateDigitalTwinHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, DigitalTwinUpdateDigitalTwinHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, DigitalTwinUpdateDigitalTwinHeaders>> updateDigitalTwinWithServiceResponseAsync(String id, List<Object> digitalTwinPatch) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter id is required and cannot be null.");
        }
        if (digitalTwinPatch == null) {
            throw new IllegalArgumentException("Parameter digitalTwinPatch is required and cannot be null.");
        }
        Validator.validate(digitalTwinPatch);
        String apiVersion = "2020-09-30";
        return this.service.updateDigitalTwin(id, digitalTwinPatch, null, "2020-09-30").flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, DigitalTwinUpdateDigitalTwinHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, DigitalTwinUpdateDigitalTwinHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = DigitalTwinsImpl.this.updateDigitalTwinDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void updateDigitalTwin(String id, List<Object> digitalTwinPatch, String ifMatch) {
        ((ServiceResponseWithHeaders)this.updateDigitalTwinWithServiceResponseAsync(id, digitalTwinPatch, ifMatch).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateDigitalTwinAsync(String id, List<Object> digitalTwinPatch, String ifMatch, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateDigitalTwinWithServiceResponseAsync(id, digitalTwinPatch, ifMatch), serviceCallback);
    }

    @Override
    public Observable<Void> updateDigitalTwinAsync(String id, List<Object> digitalTwinPatch, String ifMatch) {
        return this.updateDigitalTwinWithServiceResponseAsync(id, digitalTwinPatch, ifMatch).map((Func1)new Func1<ServiceResponseWithHeaders<Void, DigitalTwinUpdateDigitalTwinHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, DigitalTwinUpdateDigitalTwinHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, DigitalTwinUpdateDigitalTwinHeaders>> updateDigitalTwinWithServiceResponseAsync(String id, List<Object> digitalTwinPatch, String ifMatch) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter id is required and cannot be null.");
        }
        if (digitalTwinPatch == null) {
            throw new IllegalArgumentException("Parameter digitalTwinPatch is required and cannot be null.");
        }
        Validator.validate(digitalTwinPatch);
        String apiVersion = "2020-09-30";
        return this.service.updateDigitalTwin(id, digitalTwinPatch, ifMatch, "2020-09-30").flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, DigitalTwinUpdateDigitalTwinHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, DigitalTwinUpdateDigitalTwinHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = DigitalTwinsImpl.this.updateDigitalTwinDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, DigitalTwinUpdateDigitalTwinHeaders> updateDigitalTwinDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).buildWithHeaders(response, DigitalTwinUpdateDigitalTwinHeaders.class);
    }

    @Override
    public Object invokeRootLevelCommand(String id, String commandName) {
        return ((ServiceResponseWithHeaders)this.invokeRootLevelCommandWithServiceResponseAsync(id, commandName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> invokeRootLevelCommandAsync(String id, String commandName, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.invokeRootLevelCommandWithServiceResponseAsync(id, commandName), serviceCallback);
    }

    @Override
    public Observable<Object> invokeRootLevelCommandAsync(String id, String commandName) {
        return this.invokeRootLevelCommandWithServiceResponseAsync(id, commandName).map((Func1)new Func1<ServiceResponseWithHeaders<Object, DigitalTwinInvokeRootLevelCommandHeaders>, Object>(){

            public Object call(ServiceResponseWithHeaders<Object, DigitalTwinInvokeRootLevelCommandHeaders> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Object, DigitalTwinInvokeRootLevelCommandHeaders>> invokeRootLevelCommandWithServiceResponseAsync(String id, String commandName) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter id is required and cannot be null.");
        }
        if (commandName == null) {
            throw new IllegalArgumentException("Parameter commandName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.invokeRootLevelCommand(id, commandName, null, "2020-09-30", null, null).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Object, DigitalTwinInvokeRootLevelCommandHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Object, DigitalTwinInvokeRootLevelCommandHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = DigitalTwinsImpl.this.invokeRootLevelCommandDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object invokeRootLevelCommand(String id, String commandName, Object payload, Integer connectTimeoutInSeconds, Integer responseTimeoutInSeconds) {
        return ((ServiceResponseWithHeaders)this.invokeRootLevelCommandWithServiceResponseAsync(id, commandName, payload, connectTimeoutInSeconds, responseTimeoutInSeconds).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> invokeRootLevelCommandAsync(String id, String commandName, Object payload, Integer connectTimeoutInSeconds, Integer responseTimeoutInSeconds, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.invokeRootLevelCommandWithServiceResponseAsync(id, commandName, payload, connectTimeoutInSeconds, responseTimeoutInSeconds), serviceCallback);
    }

    @Override
    public Observable<Object> invokeRootLevelCommandAsync(String id, String commandName, Object payload, Integer connectTimeoutInSeconds, Integer responseTimeoutInSeconds) {
        return this.invokeRootLevelCommandWithServiceResponseAsync(id, commandName, payload, connectTimeoutInSeconds, responseTimeoutInSeconds).map((Func1)new Func1<ServiceResponseWithHeaders<Object, DigitalTwinInvokeRootLevelCommandHeaders>, Object>(){

            public Object call(ServiceResponseWithHeaders<Object, DigitalTwinInvokeRootLevelCommandHeaders> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Object, DigitalTwinInvokeRootLevelCommandHeaders>> invokeRootLevelCommandWithServiceResponseAsync(String id, String commandName, Object payload, Integer connectTimeoutInSeconds, Integer responseTimeoutInSeconds) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter id is required and cannot be null.");
        }
        if (commandName == null) {
            throw new IllegalArgumentException("Parameter commandName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.invokeRootLevelCommand(id, commandName, payload, "2020-09-30", connectTimeoutInSeconds, responseTimeoutInSeconds).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Object, DigitalTwinInvokeRootLevelCommandHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Object, DigitalTwinInvokeRootLevelCommandHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = DigitalTwinsImpl.this.invokeRootLevelCommandDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Object, DigitalTwinInvokeRootLevelCommandHeaders> invokeRootLevelCommandDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Object>(){}.getType()).buildWithHeaders(response, DigitalTwinInvokeRootLevelCommandHeaders.class);
    }

    @Override
    public Object invokeComponentCommand(String id, String componentPath, String commandName) {
        return ((ServiceResponseWithHeaders)this.invokeComponentCommandWithServiceResponseAsync(id, componentPath, commandName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> invokeComponentCommandAsync(String id, String componentPath, String commandName, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.invokeComponentCommandWithServiceResponseAsync(id, componentPath, commandName), serviceCallback);
    }

    @Override
    public Observable<Object> invokeComponentCommandAsync(String id, String componentPath, String commandName) {
        return this.invokeComponentCommandWithServiceResponseAsync(id, componentPath, commandName).map((Func1)new Func1<ServiceResponseWithHeaders<Object, DigitalTwinInvokeComponentCommandHeaders>, Object>(){

            public Object call(ServiceResponseWithHeaders<Object, DigitalTwinInvokeComponentCommandHeaders> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Object, DigitalTwinInvokeComponentCommandHeaders>> invokeComponentCommandWithServiceResponseAsync(String id, String componentPath, String commandName) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter id is required and cannot be null.");
        }
        if (componentPath == null) {
            throw new IllegalArgumentException("Parameter componentPath is required and cannot be null.");
        }
        if (commandName == null) {
            throw new IllegalArgumentException("Parameter commandName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.invokeComponentCommand(id, componentPath, commandName, null, "2020-09-30", null, null).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Object, DigitalTwinInvokeComponentCommandHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Object, DigitalTwinInvokeComponentCommandHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = DigitalTwinsImpl.this.invokeComponentCommandDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object invokeComponentCommand(String id, String componentPath, String commandName, Object payload, Integer connectTimeoutInSeconds, Integer responseTimeoutInSeconds) {
        return ((ServiceResponseWithHeaders)this.invokeComponentCommandWithServiceResponseAsync(id, componentPath, commandName, payload, connectTimeoutInSeconds, responseTimeoutInSeconds).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> invokeComponentCommandAsync(String id, String componentPath, String commandName, Object payload, Integer connectTimeoutInSeconds, Integer responseTimeoutInSeconds, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.invokeComponentCommandWithServiceResponseAsync(id, componentPath, commandName, payload, connectTimeoutInSeconds, responseTimeoutInSeconds), serviceCallback);
    }

    @Override
    public Observable<Object> invokeComponentCommandAsync(String id, String componentPath, String commandName, Object payload, Integer connectTimeoutInSeconds, Integer responseTimeoutInSeconds) {
        return this.invokeComponentCommandWithServiceResponseAsync(id, componentPath, commandName, payload, connectTimeoutInSeconds, responseTimeoutInSeconds).map((Func1)new Func1<ServiceResponseWithHeaders<Object, DigitalTwinInvokeComponentCommandHeaders>, Object>(){

            public Object call(ServiceResponseWithHeaders<Object, DigitalTwinInvokeComponentCommandHeaders> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Object, DigitalTwinInvokeComponentCommandHeaders>> invokeComponentCommandWithServiceResponseAsync(String id, String componentPath, String commandName, Object payload, Integer connectTimeoutInSeconds, Integer responseTimeoutInSeconds) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter id is required and cannot be null.");
        }
        if (componentPath == null) {
            throw new IllegalArgumentException("Parameter componentPath is required and cannot be null.");
        }
        if (commandName == null) {
            throw new IllegalArgumentException("Parameter commandName is required and cannot be null.");
        }
        String apiVersion = "2020-09-30";
        return this.service.invokeComponentCommand(id, componentPath, commandName, payload, "2020-09-30", connectTimeoutInSeconds, responseTimeoutInSeconds).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Object, DigitalTwinInvokeComponentCommandHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Object, DigitalTwinInvokeComponentCommandHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = DigitalTwinsImpl.this.invokeComponentCommandDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Object, DigitalTwinInvokeComponentCommandHeaders> invokeComponentCommandDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Object>(){}.getType()).buildWithHeaders(response, DigitalTwinInvokeComponentCommandHeaders.class);
    }

    static interface DigitalTwinsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.sdk.iot.service.digitaltwin.generated.DigitalTwins getDigitalTwin"})
        @GET(value="digitaltwins/{id}")
        public Observable<Response<ResponseBody>> getDigitalTwin(@Path(value="id") String var1, @Query(value="api-version") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.sdk.iot.service.digitaltwin.generated.DigitalTwins updateDigitalTwin"})
        @PATCH(value="digitaltwins/{id}")
        public Observable<Response<ResponseBody>> updateDigitalTwin(@Path(value="id") String var1, @Body List<Object> var2, @Header(value="If-Match") String var3, @Query(value="api-version") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.sdk.iot.service.digitaltwin.generated.DigitalTwins invokeRootLevelCommand"})
        @POST(value="digitaltwins/{id}/commands/{commandName}")
        public Observable<Response<ResponseBody>> invokeRootLevelCommand(@Path(value="id") String var1, @Path(value="commandName") String var2, @Body Object var3, @Query(value="api-version") String var4, @Query(value="connectTimeoutInSeconds") Integer var5, @Query(value="responseTimeoutInSeconds") Integer var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.sdk.iot.service.digitaltwin.generated.DigitalTwins invokeComponentCommand"})
        @POST(value="digitaltwins/{id}/components/{componentPath}/commands/{commandName}")
        public Observable<Response<ResponseBody>> invokeComponentCommand(@Path(value="id") String var1, @Path(value="componentPath") String var2, @Path(value="commandName") String var3, @Body Object var4, @Query(value="api-version") String var5, @Query(value="connectTimeoutInSeconds") Integer var6, @Query(value="responseTimeoutInSeconds") Integer var7);
    }
}

