/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.exceptions;

public enum ErrorCodeDescription {
    UnclassifiedErrorCode,
    InvalidProtocolVersion,
    InvalidOperation,
    ArgumentInvalid,
    ArgumentNull,
    IotHubFormatError,
    DeviceDefinedMultipleTimes,
    BulkRegistryOperationFailure,
    IotHubUnauthorizedAccess,
    IotHubQuotaExceeded,
    DeviceMaximumQueueDepthExceeded,
    DeviceNotFound,
    ModuleNotFound,
    DeviceAlreadyExists,
    ModuleAlreadyExistsOnDevice,
    MessageTooLarge,
    TooManyDevices,
    ThrottleBacklogLimitExceeded,
    ServerError,
    DeviceNotOnline,
    BadFormat,
    Unauthorized,
    Forbidden,
    NotFound,
    Conflict,
    PreconditionFailed,
    RequestEntityTooLarge,
    ThrottlingException,
    InternalServerError,
    ServiceUnavailable;


    public static ErrorCodeDescription Parse(int errorCode) {
        switch (errorCode) {
            case 400001: {
                return InvalidProtocolVersion;
            }
            case 400003: {
                return InvalidOperation;
            }
            case 400004: {
                return ArgumentInvalid;
            }
            case 400005: {
                return ArgumentNull;
            }
            case 400006: {
                return IotHubFormatError;
            }
            case 400011: {
                return DeviceDefinedMultipleTimes;
            }
            case 400013: {
                return BulkRegistryOperationFailure;
            }
            case 401002: {
                return IotHubUnauthorizedAccess;
            }
            case 403002: {
                return IotHubQuotaExceeded;
            }
            case 403004: {
                return DeviceMaximumQueueDepthExceeded;
            }
            case 404001: {
                return DeviceNotFound;
            }
            case 404010: {
                return ModuleNotFound;
            }
            case 404103: {
                return DeviceNotOnline;
            }
            case 409001: {
                return DeviceAlreadyExists;
            }
            case 409301: {
                return ModuleAlreadyExistsOnDevice;
            }
            case 412: 
            case 412001: {
                return PreconditionFailed;
            }
            case 413001: {
                return MessageTooLarge;
            }
            case 413002: {
                return TooManyDevices;
            }
            case 429: 
            case 429001: {
                return ThrottlingException;
            }
            case 429002: {
                return ThrottleBacklogLimitExceeded;
            }
            case 500001: {
                return ServerError;
            }
            case 503: 
            case 503001: {
                return ServiceUnavailable;
            }
            case 400: {
                return BadFormat;
            }
            case 401: {
                return Unauthorized;
            }
            case 403: {
                return Forbidden;
            }
            case 404: {
                return NotFound;
            }
            case 409: {
                return Conflict;
            }
            case 413: {
                return RequestEntityTooLarge;
            }
            case 500: {
                return InternalServerError;
            }
        }
        return UnclassifiedErrorCode;
    }
}

