/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.exceptions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;

public class ErrorMessageParser {
    public static String bestErrorMessage(String fullErrorMessage) {
        ErrorMessage subMessage;
        if (fullErrorMessage == null || fullErrorMessage.isEmpty()) {
            return "";
        }
        Gson gson = new GsonBuilder().create();
        String rootMessage = fullErrorMessage;
        String rootException = null;
        try {
            subMessage = (ErrorMessage)gson.fromJson(rootMessage, ErrorMessage.class);
        }
        catch (JsonSyntaxException e) {
            subMessage = new ErrorMessage();
        }
        while (subMessage != null && subMessage.message != null) {
            rootMessage = subMessage.message;
            if (subMessage.exception != null) {
                rootException = subMessage.exception;
            }
            try {
                subMessage = (ErrorMessage)gson.fromJson(rootMessage.substring(rootMessage.indexOf(123)), ErrorMessage.class);
            }
            catch (JsonSyntaxException | StringIndexOutOfBoundsException e) {
                // empty catch block
                break;
            }
        }
        if (rootException != null) {
            rootMessage = rootMessage + " " + rootException;
        }
        return rootMessage;
    }

    public static int bestErrorCode(String fullErrorMessage) {
        String errorCodeJsonKey = "errorCode";
        if (fullErrorMessage == null || fullErrorMessage.isEmpty()) {
            return ErrorMessageParser.getDefaultErrorCode();
        }
        try {
            JsonPrimitive errorCodeJson;
            JsonObject errorMessageJson = (JsonObject)new GsonBuilder().create().fromJson(fullErrorMessage, JsonObject.class);
            if (errorMessageJson.has(errorCodeJsonKey) && errorMessageJson.get(errorCodeJsonKey).isJsonPrimitive() && (errorCodeJson = errorMessageJson.getAsJsonPrimitive(errorCodeJsonKey)).isNumber()) {
                return errorCodeJson.getAsInt();
            }
        }
        catch (JsonParseException e) {
            return ErrorMessageParser.getDefaultErrorCode();
        }
        return ErrorMessageParser.getDefaultErrorCode();
    }

    public static int getDefaultErrorCode() {
        return 0;
    }

    static class ErrorMessage {
        @SerializedName(value="Message")
        String message;
        @SerializedName(value="ExceptionMessage")
        String exception;

        ErrorMessage() {
        }
    }
}

