/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.exceptions;

import com.microsoft.azure.sdk.iot.service.exceptions.ErrorCodeDescription;
import com.microsoft.azure.sdk.iot.service.exceptions.ErrorMessageParser;

public class IotHubException
extends Exception {
    protected int errorCode;
    protected ErrorCodeDescription errorCodeDescription;

    public IotHubException() {
        this((String)null);
    }

    public IotHubException(String message) {
        this(message, ErrorMessageParser.getDefaultErrorCode(), ErrorCodeDescription.UnclassifiedErrorCode);
    }

    IotHubException(String message, int errorCode, ErrorCodeDescription errorCodeDescription) {
        super(message);
        this.errorCodeDescription = errorCodeDescription;
        this.errorCode = errorCode;
    }

    public IotHubException(int errorCode, String message) {
        super(message);
        this.errorCodeDescription = ErrorCodeDescription.Parse(errorCode);
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public ErrorCodeDescription getErrorCodeDescription() {
        return this.errorCodeDescription;
    }
}

