/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.exceptions;

import com.microsoft.azure.sdk.iot.service.exceptions.ErrorCodeDescription;
import com.microsoft.azure.sdk.iot.service.exceptions.ErrorMessageParser;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubBadFormatException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubBadGatewayException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubConflictException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubGatewayTimeoutException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubInternalServerErrorException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubNotFoundException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubPreconditionFailedException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubServerBusyException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubTooManyDevicesException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubTooManyRequestsException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubUnauthorizedException;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.nio.charset.StandardCharsets;

public class IotHubExceptionManager {
    public static void httpResponseVerification(HttpResponse httpResponse) throws IotHubBadFormatException, IotHubUnauthorizedException, IotHubTooManyDevicesException, IotHubPreconditionFailedException, IotHubTooManyRequestsException, IotHubInternalServerErrorException, IotHubServerBusyException, IotHubBadGatewayException, IotHubNotFoundException, IotHubGatewayTimeoutException, IotHubException {
        int responseStatus = httpResponse.getStatus();
        String errorMessage = ErrorMessageParser.bestErrorMessage(new String(httpResponse.getErrorReason(), StandardCharsets.UTF_8));
        int errorCode = ErrorMessageParser.bestErrorCode(errorMessage);
        if (errorCode == ErrorMessageParser.getDefaultErrorCode()) {
            errorCode = responseStatus;
        }
        ErrorCodeDescription errorCodeDescription = ErrorCodeDescription.Parse(errorCode);
        if (400 == responseStatus) {
            throw new IotHubBadFormatException(errorMessage, errorCode, errorCodeDescription);
        }
        if (401 == responseStatus) {
            throw new IotHubUnauthorizedException(errorMessage, errorCode, errorCodeDescription);
        }
        if (403 == responseStatus) {
            throw new IotHubTooManyDevicesException(errorMessage, errorCode, errorCodeDescription);
        }
        if (404 == responseStatus) {
            throw new IotHubNotFoundException(errorMessage, errorCode, errorCodeDescription);
        }
        if (409 == responseStatus) {
            throw new IotHubConflictException(errorMessage, errorCode, errorCodeDescription);
        }
        if (412 == responseStatus) {
            throw new IotHubPreconditionFailedException(errorMessage, errorCode, errorCodeDescription);
        }
        if (429 == responseStatus) {
            throw new IotHubTooManyRequestsException(errorMessage, errorCode, errorCodeDescription);
        }
        if (500 == responseStatus) {
            throw new IotHubInternalServerErrorException(errorMessage, errorCode, errorCodeDescription);
        }
        if (502 == responseStatus) {
            throw new IotHubBadGatewayException(errorMessage, errorCode, errorCodeDescription);
        }
        if (503 == responseStatus) {
            throw new IotHubServerBusyException(errorMessage, errorCode, errorCodeDescription);
        }
        if (504 == responseStatus) {
            throw new IotHubGatewayTimeoutException(errorMessage, errorCode, errorCodeDescription);
        }
        if (responseStatus > 300) {
            if (errorMessage.isEmpty()) {
                throw new IotHubException("Unknown error reason");
            }
            throw new IotHubException(errorMessage, errorCode, errorCodeDescription);
        }
    }

    public static IotHubException mapException(int responseStatus, String description) {
        ErrorCodeDescription errorCodeDescription = ErrorCodeDescription.Parse(responseStatus);
        if (400 == responseStatus) {
            return new IotHubBadFormatException(description, responseStatus, errorCodeDescription);
        }
        if (401 == responseStatus) {
            return new IotHubUnauthorizedException(description, responseStatus, errorCodeDescription);
        }
        if (403 == responseStatus) {
            return new IotHubTooManyDevicesException(description, responseStatus, errorCodeDescription);
        }
        if (404 == responseStatus) {
            return new IotHubNotFoundException(description, responseStatus, errorCodeDescription);
        }
        if (409 == responseStatus) {
            return new IotHubConflictException(description, responseStatus, errorCodeDescription);
        }
        if (412 == responseStatus) {
            return new IotHubPreconditionFailedException(description, responseStatus, errorCodeDescription);
        }
        if (429 == responseStatus) {
            return new IotHubTooManyRequestsException(description, responseStatus, errorCodeDescription);
        }
        if (500 == responseStatus) {
            return new IotHubInternalServerErrorException(description, responseStatus, errorCodeDescription);
        }
        if (502 == responseStatus) {
            return new IotHubBadGatewayException(description, responseStatus, errorCodeDescription);
        }
        if (503 == responseStatus) {
            return new IotHubServerBusyException(description, responseStatus, errorCodeDescription);
        }
        if (504 == responseStatus) {
            return new IotHubGatewayTimeoutException(description, responseStatus, errorCodeDescription);
        }
        return new IotHubException(description, responseStatus, errorCodeDescription);
    }
}

