/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.jobs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.microsoft.azure.sdk.iot.service.jobs.JobStatistics;
import com.microsoft.azure.sdk.iot.service.jobs.ScheduledJobStatus;
import com.microsoft.azure.sdk.iot.service.jobs.ScheduledJobType;
import com.microsoft.azure.sdk.iot.service.jobs.serializers.JobsResponseParser;
import com.microsoft.azure.sdk.iot.service.jobs.serializers.JobsStatisticsParser;
import com.microsoft.azure.sdk.iot.service.methods.DirectMethodResponse;
import com.microsoft.azure.sdk.iot.service.twin.Twin;
import com.microsoft.azure.sdk.iot.service.twin.TwinState;
import java.util.Date;

public class ScheduledJob {
    private final String jobId;
    private final String queryCondition;
    private final Date createdTime;
    private final Date startTime;
    private final Date lastUpdatedDateTime;
    private final Date endTime;
    private final Long maxExecutionTimeInSeconds;
    private final ScheduledJobType jobType;
    private final ScheduledJobStatus jobStatus;
    private String cloudToDeviceMethod;
    private Twin updateTwin;
    private final String failureReason;
    private final String statusMessage;
    private JobStatistics jobStatistics;
    private final String deviceId;
    private final String parentJobId;
    private DirectMethodResponse outcomeResult;
    private String error;

    public ScheduledJob(String json) throws JsonParseException, IllegalArgumentException {
        TwinState twinState;
        if (json == null) {
            throw new IllegalArgumentException("null body");
        }
        JobsResponseParser jobsResponseParser = JobsResponseParser.createFromJson(json);
        this.jobId = jobsResponseParser.getJobId();
        this.queryCondition = jobsResponseParser.getQueryCondition();
        this.createdTime = jobsResponseParser.getCreatedTimeDate();
        this.startTime = jobsResponseParser.getStartTimeDate();
        this.endTime = jobsResponseParser.getEndTimeDate();
        this.lastUpdatedDateTime = jobsResponseParser.getLastUpdatedTimeDate();
        this.maxExecutionTimeInSeconds = jobsResponseParser.getMaxExecutionTimeInSeconds();
        this.jobType = ScheduledJobType.valueOf(jobsResponseParser.getType());
        this.jobStatus = ScheduledJobStatus.valueOf(jobsResponseParser.getJobsStatus());
        if (jobsResponseParser.getCloudToDeviceMethod() != null) {
            this.cloudToDeviceMethod = jobsResponseParser.getCloudToDeviceMethod().toJson();
        }
        if (jobsResponseParser.getOutcome() != null && this.jobType == ScheduledJobType.scheduleDeviceMethod) {
            try {
                this.outcomeResult = new DirectMethodResponse(jobsResponseParser.getCloudToDeviceMethod().getStatus(), new GsonBuilder().create().toJsonTree(jobsResponseParser.getCloudToDeviceMethod().getPayload()));
            }
            catch (IllegalArgumentException e) {
                this.outcomeResult = null;
            }
        }
        if (jobsResponseParser.getError() != null) {
            this.error = jobsResponseParser.getError().toJson();
        }
        if ((twinState = jobsResponseParser.getUpdateTwin()) != null) {
            this.updateTwin = twinState.getDeviceId() == null || twinState.getDeviceId().isEmpty() ? new Twin() : new Twin(twinState.getDeviceId());
            this.updateTwin.setETag(twinState.getETag());
            if (twinState.getTags() != null && twinState.getTags().size() > 0) {
                this.updateTwin.getTags().putAll(twinState.getTags());
            }
            if (twinState.getDesiredProperties() != null && twinState.getDesiredProperties().size() > 0) {
                this.updateTwin.getDesiredProperties().putAll(twinState.getDesiredProperties());
            }
        }
        this.failureReason = jobsResponseParser.getFailureReason();
        this.statusMessage = jobsResponseParser.getStatusMessage();
        JobsStatisticsParser jobsStatisticsParser = jobsResponseParser.getDeviceJobStatistics();
        if (jobsStatisticsParser != null) {
            this.jobStatistics = new JobStatistics(jobsStatisticsParser);
        }
        this.deviceId = jobsResponseParser.getDeviceId();
        this.parentJobId = jobsResponseParser.getParentJobId();
    }

    public String toString() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        return gson.toJson((Object)this);
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getQueryCondition() {
        return this.queryCondition;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Long getMaxExecutionTimeInSeconds() {
        return this.maxExecutionTimeInSeconds;
    }

    public ScheduledJobType getJobType() {
        return this.jobType;
    }

    public ScheduledJobStatus getJobStatus() {
        return this.jobStatus;
    }

    public String getCloudToDeviceMethod() {
        return this.cloudToDeviceMethod;
    }

    public Twin getUpdateTwin() {
        return this.updateTwin;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public JobStatistics getJobStatistics() {
        return this.jobStatistics;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getParentJobId() {
        return this.parentJobId;
    }

    public DirectMethodResponse getOutcomeResult() {
        return this.outcomeResult;
    }

    public String getError() {
        return this.error;
    }
}

