/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.jobs.serializers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.service.ParserUtility;
import com.microsoft.azure.sdk.iot.service.jobs.serializers.JobQueryResponseError;
import com.microsoft.azure.sdk.iot.service.jobs.serializers.JobsStatisticsParser;
import com.microsoft.azure.sdk.iot.service.methods.serializers.MethodParser;
import com.microsoft.azure.sdk.iot.service.twin.TwinState;
import java.util.Date;
import java.util.Map;

public class JobsResponseParser {
    private static final String JOBID_TAG = "jobId";
    @SerializedName(value="jobId")
    private String jobId;
    private static final String QUERYCONDITION_TAG = "queryCondition";
    @SerializedName(value="queryCondition")
    private String queryCondition;
    private static final String CREATETIME_TAG = "createdTime";
    @SerializedName(value="createdTime")
    private String createdTime;
    private static final String CREATE_TIME_UTC_TAG = "createdDateTimeUtc";
    @SerializedName(value="createdDateTimeUtc")
    private String createdTimeUTC;
    @Expose(deserialize=false)
    private Date createdTimeDate;
    private static final String STARTTIME_TAG = "startTime";
    @SerializedName(value="startTime")
    private String startTime;
    private static final String START_TIME_UTC_TAG = "startTimeUtc";
    @SerializedName(value="startTimeUtc")
    private String startTimeUTC;
    @Expose(deserialize=false)
    private Date startTimeDate;
    private static final String ENDTIME_TAG = "endTime";
    @SerializedName(value="endTime")
    private String endTime;
    private static final String END_TIME_UTC_TAG = "endTimeUtc";
    @SerializedName(value="endTimeUtc")
    private String endTimeUTC;
    @Expose(deserialize=false)
    private Date endTimeDate;
    private static final String LAST_UPDATED_TIME_UTC_TAG = "lastUpdatedDateTimeUtc";
    @SerializedName(value="lastUpdatedDateTimeUtc")
    private String lastUpdatedTime;
    @Expose(serialize=false)
    private Date lastUpdatedTimeDate;
    private static final String MAXEXECUTIONTIMEINSECONDS_TAG = "maxExecutionTimeInSeconds";
    @SerializedName(value="maxExecutionTimeInSeconds")
    private Long maxExecutionTimeInSeconds;
    private static final String TYPE_TAG = "type";
    @SerializedName(value="type")
    private String type;
    private static final String JOB_TYPE_TAG = "jobType";
    @SerializedName(value="jobType")
    private String jobType;
    private static final String STATUS_TAG = "status";
    @SerializedName(value="status")
    private String jobsStatus;
    private static final String CLOUDTODEVICEMETHOD_TAG = "cloudToDeviceMethod";
    @SerializedName(value="cloudToDeviceMethod")
    private MethodParser cloudToDeviceMethod;
    private static final String OUTCOME_TAG = "outcome";
    @SerializedName(value="outcome")
    private JsonElement outcome;
    private static final String DEVICE_METHOD_RESPONSE_TAG = "deviceMethodResponse";
    private MethodParser methodResponse;
    private static final String UPDATETWIN_TAG = "updateTwin";
    @SerializedName(value="updateTwin")
    private TwinState updateTwin = null;
    private static final String FAILUREREASON_TAG = "failureReason";
    @SerializedName(value="failureReason")
    private String failureReason;
    private static final String STATUSMESSAGE_TAG = "statusMessage";
    @SerializedName(value="statusMessage")
    private String statusMessage;
    private static final String DEVICEJOBSSTATISTICS_TAG = "deviceJobStatistics";
    @SerializedName(value="deviceJobStatistics")
    private JobsStatisticsParser deviceJobStatistics;
    private static final String DEVICEID_TAG = "deviceId";
    @SerializedName(value="deviceId")
    private String deviceId;
    private static final String PARENTJOBID_TAG = "parentJobId";
    @SerializedName(value="parentJobId")
    private String parentJobId;
    private static final String ERROR_TAG = "error";
    @SerializedName(value="error")
    private JobQueryResponseError error;

    public static JobsResponseParser createFromJson(String json) throws IllegalArgumentException, JsonParseException {
        Map map;
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("Json is null or empty");
        }
        JobsResponseParser jobsResponseParser = (JobsResponseParser)gson.fromJson(json, JobsResponseParser.class);
        if (jobsResponseParser.jobId == null || jobsResponseParser.jobId.isEmpty()) {
            throw new IllegalArgumentException("Json do not contains jobId");
        }
        if ((jobsResponseParser.type == null || jobsResponseParser.type.isEmpty()) && (jobsResponseParser.jobType == null || jobsResponseParser.jobType.isEmpty())) {
            throw new IllegalArgumentException("Json do not contains type");
        }
        if (jobsResponseParser.type != null && jobsResponseParser.jobType != null) {
            throw new IllegalArgumentException("Json contains both type and jobType");
        }
        if (jobsResponseParser.jobsStatus == null || jobsResponseParser.jobsStatus.isEmpty()) {
            throw new IllegalArgumentException("Json do not contains status");
        }
        if (jobsResponseParser.type == null) {
            jobsResponseParser.type = jobsResponseParser.jobType;
        }
        if ((map = (Map)gson.fromJson(json, Map.class)).containsKey(UPDATETWIN_TAG)) {
            jobsResponseParser.updateTwin = new TwinState(gson.toJson(map.get(UPDATETWIN_TAG)));
        }
        if (map.containsKey(CLOUDTODEVICEMETHOD_TAG)) {
            jobsResponseParser.cloudToDeviceMethod.fromJson(gson.toJson(map.get(CLOUDTODEVICEMETHOD_TAG)));
        }
        if (map.containsKey(OUTCOME_TAG)) {
            Map responseMap = (Map)gson.fromJson(jobsResponseParser.outcome, Map.class);
            if (responseMap.containsKey(DEVICE_METHOD_RESPONSE_TAG)) {
                MethodParser methodParserResponse = new MethodParser();
                Object value = responseMap.get(DEVICE_METHOD_RESPONSE_TAG);
                if (value == null) {
                    jobsResponseParser.methodResponse = null;
                } else {
                    String outcomeResponse = gson.toJson(value);
                    methodParserResponse.fromJson(outcomeResponse);
                    jobsResponseParser.methodResponse = methodParserResponse;
                }
            } else {
                MethodParser methodParserResponse = new MethodParser();
                methodParserResponse.fromJson(gson.toJson(map.get(OUTCOME_TAG)));
                jobsResponseParser.methodResponse = methodParserResponse;
            }
        }
        if (jobsResponseParser.createdTime != null && jobsResponseParser.createdTimeUTC != null) {
            throw new IllegalArgumentException("Both createdTime and createdTimeUTC cannot be sent at the same time");
        }
        if (jobsResponseParser.createdTime != null) {
            try {
                jobsResponseParser.createdTimeDate = ParserUtility.getDateTimeUtc(jobsResponseParser.createdTime);
            }
            catch (IllegalArgumentException e) {
                jobsResponseParser.createdTimeDate = null;
            }
        } else if (jobsResponseParser.createdTimeUTC != null) {
            try {
                jobsResponseParser.createdTimeDate = ParserUtility.getDateTimeUtc(jobsResponseParser.createdTimeUTC);
            }
            catch (IllegalArgumentException e) {
                jobsResponseParser.createdTimeDate = null;
            }
        }
        if (jobsResponseParser.startTime != null && jobsResponseParser.startTimeUTC != null) {
            throw new IllegalArgumentException("Both startTime and startTimeUTC cannot be sent at the same time");
        }
        if (jobsResponseParser.startTime != null) {
            try {
                jobsResponseParser.startTimeDate = ParserUtility.getDateTimeUtc(jobsResponseParser.startTime);
            }
            catch (IllegalArgumentException e) {
                jobsResponseParser.startTimeDate = null;
            }
        } else if (jobsResponseParser.startTimeUTC != null) {
            try {
                jobsResponseParser.startTimeDate = ParserUtility.getDateTimeUtc(jobsResponseParser.startTimeUTC);
            }
            catch (IllegalArgumentException e) {
                jobsResponseParser.startTimeDate = null;
            }
        }
        if (jobsResponseParser.endTime != null && jobsResponseParser.endTimeUTC != null) {
            throw new IllegalArgumentException("Both endTime and endTimeUTC cannot be sent at the same time");
        }
        if (jobsResponseParser.endTime != null) {
            try {
                jobsResponseParser.endTimeDate = ParserUtility.getDateTimeUtc(jobsResponseParser.endTime);
            }
            catch (IllegalArgumentException e) {
                jobsResponseParser.endTimeDate = null;
            }
        } else if (jobsResponseParser.endTimeUTC != null) {
            try {
                jobsResponseParser.endTimeDate = ParserUtility.getDateTimeUtc(jobsResponseParser.endTimeUTC);
            }
            catch (IllegalArgumentException e) {
                jobsResponseParser.endTimeDate = null;
            }
        }
        if (jobsResponseParser.lastUpdatedTime != null) {
            try {
                jobsResponseParser.lastUpdatedTimeDate = ParserUtility.getDateTimeUtc(jobsResponseParser.lastUpdatedTime);
            }
            catch (IllegalArgumentException e) {
                jobsResponseParser.lastUpdatedTimeDate = null;
            }
        }
        return jobsResponseParser;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getQueryCondition() {
        return this.queryCondition;
    }

    public Date getCreatedTimeDate() {
        return this.createdTimeDate;
    }

    public Date getStartTimeDate() {
        return this.startTimeDate;
    }

    public Date getEndTimeDate() {
        return this.endTimeDate;
    }

    public Date getLastUpdatedTimeDate() {
        return this.lastUpdatedTimeDate;
    }

    public Long getMaxExecutionTimeInSeconds() {
        return this.maxExecutionTimeInSeconds;
    }

    public String getType() {
        return this.type;
    }

    public String getJobType() {
        return this.jobType;
    }

    public String getJobsStatus() {
        return this.jobsStatus;
    }

    public MethodParser getCloudToDeviceMethod() {
        return this.cloudToDeviceMethod;
    }

    public JsonElement getOutcome() {
        return this.outcome;
    }

    public TwinState getUpdateTwin() {
        return this.updateTwin;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public JobsStatisticsParser getDeviceJobStatistics() {
        return this.deviceJobStatistics;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getParentJobId() {
        return this.parentJobId;
    }

    public JobQueryResponseError getError() {
        return this.error;
    }
}

